/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerConfigModel {
    private static final String LAST_SELECTED_CONFIGURATION_NAME = "last.selected.configuration.name";
    private ProfilingConfiguration myProfilingConfiguration;
    @NotNull
    private List<ProfilingConfiguration> myCustomProfilingConfigurations;
    @NotNull
    private List<ProfilingConfiguration> myCustomProfilingConfigurationsDeviceFiltered;
    @NotNull
    private List<ProfilingConfiguration> myDefaultProfilingConfigurations;
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private CpuProfilerStage myProfilerStage;
    private AspectObserver myAspectObserver;

    public CpuProfilerConfigModel(@NotNull StudioProfilers profilers, @NotNull CpuProfilerStage profilerStage) {
        this.myProfilers = profilers;
        this.myProfilerStage = profilerStage;
        this.myCustomProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myCustomProfilingConfigurationsDeviceFiltered = new ArrayList<ProfilingConfiguration>();
        this.myDefaultProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myAspectObserver = new AspectObserver();
        this.myProfilerStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION, this::updateProfilingConfigurations);
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        return this.myProfilingConfiguration;
    }

    public void setProfilingConfiguration(@NotNull ProfilingConfiguration configuration) {
        this.myProfilingConfiguration = configuration;
        this.myProfilerStage.getAspect().changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
        this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().setValue(LAST_SELECTED_CONFIGURATION_NAME, configuration.getName());
    }

    @NotNull
    public List<ProfilingConfiguration> getCustomProfilingConfigurations() {
        return this.myCustomProfilingConfigurations;
    }

    @NotNull
    public List<ProfilingConfiguration> getCustomProfilingConfigurationsDeviceFiltered() {
        return this.myCustomProfilingConfigurationsDeviceFiltered;
    }

    @NotNull
    public List<ProfilingConfiguration> getDefaultProfilingConfigurations() {
        return this.myDefaultProfilingConfigurations;
    }

    public void updateProfilingConfigurations() {
        boolean isSimpleperfEnabled;
        List<ProfilingConfiguration> savedConfigs = this.myProfilers.getIdeServices().getUserCpuProfilerConfigs();
        this.myCustomProfilingConfigurations = this.filterConfigurations(savedConfigs, false);
        this.myCustomProfilingConfigurationsDeviceFiltered = this.filterConfigurations(savedConfigs, true);
        List<ProfilingConfiguration> defaultConfigs = this.myProfilers.getIdeServices().getDefaultCpuProfilerConfigs();
        this.myDefaultProfilingConfigurations = this.filterConfigurations(defaultConfigs, true);
        Common.Device selectedDevice = this.myProfilers.getDevice();
        boolean bl = isSimpleperfEnabled = selectedDevice != null && selectedDevice.getFeatureLevel() >= 26;
        if (this.myProfilingConfiguration == null) {
            String selectedConfigName = this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().getValue(LAST_SELECTED_CONFIGURATION_NAME, "");
            ProfilingConfiguration selectedConfig = Stream.concat(defaultConfigs.stream(), savedConfigs.stream()).filter(c -> c.getName().equals(selectedConfigName)).findFirst().orElse(null);
            this.myProfilingConfiguration = selectedConfig != null ? selectedConfig : (this.myProfilers.getIdeServices().isNativeProfilingConfigurationPreferred() && isSimpleperfEnabled ? (ProfilingConfiguration)Iterables.find(defaultConfigs, pref -> pref != null && pref.getTraceType() == Cpu.CpuTraceType.SIMPLEPERF) : (ProfilingConfiguration)Iterables.find(defaultConfigs, pref -> pref != null && pref.getTraceType() == Cpu.CpuTraceType.ART && pref.getMode() == Cpu.CpuTraceMode.SAMPLED));
        }
    }

    private List<ProfilingConfiguration> filterConfigurations(List<ProfilingConfiguration> configurations, boolean filterOnDevice) {
        Common.Device selectedDevice = this.myProfilers.getDevice();
        Predicate<ProfilingConfiguration> filter = pref -> {
            if (selectedDevice != null && pref.getRequiredDeviceLevel() > selectedDevice.getFeatureLevel() && filterOnDevice) {
                return false;
            }
            if (pref.getTraceType() == Cpu.CpuTraceType.ATRACE) {
                return this.myProfilers.getIdeServices().getFeatureConfig().isAtraceEnabled();
            }
            return true;
        };
        return configurations.stream().filter(filter).collect(Collectors.toList());
    }
}

