/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.intellij.icons.AllIcons;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

class CpuProfilerContextMenuInstaller {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final ContextMenuInstaller myInstaller;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final JComponent myContainerComponent;
    @NotNull
    private final IdeProfilerComponents myIdeComponents;

    private CpuProfilerContextMenuInstaller(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideComponents, @NotNull JComponent component, @NotNull JComponent containerComponent) {
        this.myInstaller = ideComponents.createContextMenuInstaller();
        this.myIdeComponents = ideComponents;
        this.myStage = stage;
        this.myComponent = component;
        this.myContainerComponent = containerComponent;
    }

    private void install() {
        this.installRecordMenuItem();
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isExportCpuTraceEnabled()) {
            this.installExportTraceMenuItem();
        }
        this.installCaptureNavigationMenuItems();
    }

    private void installCaptureNavigationMenuItems() {
        int shortcutModifier = AdtUiUtils.getActionMask() | 0x40;
        ProfilerAction navigateNext = new ProfilerAction.Builder("Next capture").setContainerComponent(this.myContainerComponent).setActionRunnable(() -> this.myStage.navigateNext()).setEnableBooleanSupplier(() -> !this.myStage.isImportTraceMode() && this.myStage.getTraceIdsIterator().hasNext()).setKeyStrokes(KeyStroke.getKeyStroke(39, shortcutModifier)).build();
        ProfilerAction navigatePrevious = new ProfilerAction.Builder("Previous capture").setContainerComponent(this.myContainerComponent).setActionRunnable(() -> this.myStage.navigatePrevious()).setEnableBooleanSupplier(() -> !this.myStage.isImportTraceMode() && this.myStage.getTraceIdsIterator().hasPrevious()).setKeyStrokes(KeyStroke.getKeyStroke(37, shortcutModifier)).build();
        this.myInstaller.installGenericContextMenu(this.myComponent, navigateNext);
        this.myInstaller.installGenericContextMenu(this.myComponent, navigatePrevious);
        this.myInstaller.installGenericContextMenu(this.myComponent, ContextMenuItem.SEPARATOR);
    }

    private void installExportTraceMenuItem() {
        ProfilerAction exportTrace = new ProfilerAction.Builder("Export trace...").setIcon(AllIcons.ToolbarDecorator.Export).setContainerComponent(this.myContainerComponent).setEnableBooleanSupplier(() -> !this.myStage.isImportTraceMode()).build();
        this.myInstaller.installGenericContextMenu(this.myComponent, exportTrace, x -> exportTrace.isEnabled() && this.getTraceIntersectingWithMouseX(x) != null, x -> this.myIdeComponents.createExportDialog().open(() -> "Export trace as", () -> CpuProfiler.generateCaptureFileName(this.getTraceIntersectingWithMouseX(x).getTraceType()), () -> "trace", file -> this.myStage.getStudioProfilers().getIdeServices().saveFile((File)file, output -> CpuProfiler.saveCaptureToFile(this.getTraceIntersectingWithMouseX(x).getTraceInfo(), output), null)));
        this.myInstaller.installGenericContextMenu(this.myComponent, ContextMenuItem.SEPARATOR);
    }

    private void installRecordMenuItem() {
        ProfilerAction record = new ProfilerAction.Builder(() -> this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING ? "Stop recording" : "Record CPU trace").setContainerComponent(this.myContainerComponent).setEnableBooleanSupplier(() -> this.shouldEnableCaptureButton() && !this.myStage.isImportTraceMode() && (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING || this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.IDLE)).setKeyStrokes(KeyStroke.getKeyStroke(82, AdtUiUtils.getActionMask())).setActionRunnable(() -> this.myStage.toggleCapturing()).build();
        this.myInstaller.installGenericContextMenu(this.myComponent, record);
        this.myInstaller.installGenericContextMenu(this.myComponent, ContextMenuItem.SEPARATOR);
    }

    private boolean shouldEnableCaptureButton() {
        return this.myStage.getStudioProfilers().getSessionsManager().isSessionAlive() && !this.myStage.isApiInitiatedTracingInProgress();
    }

    private CpuTraceInfo getTraceIntersectingWithMouseX(int mouseXLocation) {
        Range range = this.myStage.getStudioProfilers().getTimeline().getViewRange();
        double pos = (double)mouseXLocation / this.myComponent.getSize().getWidth() * range.getLength() + range.getMin();
        return this.myStage.getIntersectingTraceInfo(new Range(pos, pos));
    }

    public static void install(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideComponents, @NotNull JComponent component, @NotNull JComponent containerComponent) {
        CpuProfilerContextMenuInstaller menus = new CpuProfilerContextMenuInstaller(stage, ideComponents, component, containerComponent);
        menus.install();
    }
}

