/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.Notification;
import org.jetbrains.annotations.NotNull;

final class CpuProfilerNotifications {
    @NotNull
    static final Notification CAPTURE_START_FAILURE = CpuProfilerNotifications.createError("Recording failed to start", "Try recording again, or ", true);
    @NotNull
    static final Notification CAPTURE_STOP_FAILURE = CpuProfilerNotifications.createError("Recording failed to stop", "Try recording another method trace, or ", true);
    @NotNull
    static final Notification PARSING_FAILURE = CpuProfilerNotifications.createError("Trace data was not recorded", "The profiler was unable to parse the method trace data. Try recording another method trace, or ", true);
    @NotNull
    static final Notification PREPROCESS_FAILURE = CpuProfilerNotifications.createError("Trace data was not recorded", "The profiler was unable to pre-process the method trace data. Try recording another method trace, or ", true);
    @NotNull
    static final Notification PARSING_ABORTED = CpuProfilerNotifications.createError("Parsing trace file aborted", "The CPU profiler was closed before the recorded trace file could be parsed. Please record another trace.", false);
    @NotNull
    static final Notification IMPORT_TRACE_PARSING_FAILURE = CpuProfilerNotifications.createError("Trace file was not parsed", "The profiler was unable to parse the trace file. Please make sure the file selected is a valid trace. Alternatively, try importing another file, or ", true);
    @NotNull
    static final Notification IMPORT_TRACE_PARSING_ABORTED = CpuProfilerNotifications.createError("Parsing trace file aborted", "The profiler changed to a different session before the imported trace file could be parsed. Please try importing your trace file again.", false);
    @NotNull
    static final Notification ATRACE_BUFFER_OVERFLOW = CpuProfilerNotifications.createWarning("System Trace Buffer Overflow Detected", "Your capture exceeded the buffer limit, some data may be missing. Consider recording a shorter trace.", false);

    CpuProfilerNotifications() {
    }

    @NotNull
    private static Notification createNotification(@NotNull Notification.Severity severity, @NotNull String title, @NotNull String text, boolean reportBug) {
        Notification.Builder builder = new Notification.Builder(title, text).setSeverity(severity);
        if (reportBug) {
            builder.setUrl("https://issuetracker.google.com/issues/new?component=192754", "report a bug");
        }
        return builder.build();
    }

    @NotNull
    private static Notification createWarning(@NotNull String title, @NotNull String text, boolean reportBug) {
        return CpuProfilerNotifications.createNotification(Notification.Severity.WARNING, title, text, reportBug);
    }

    @NotNull
    private static Notification createError(@NotNull String title, @NotNull String text, boolean reportBug) {
        return CpuProfilerNotifications.createNotification(Notification.Severity.ERROR, title, text, reportBug);
    }
}

