/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuFramesModel;
import com.android.tools.profilers.cpu.CpuKernelModel;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.TraceIdsIterator;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureModel;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    public static final int CPU_ART_STOP_TIMEOUT_SEC = Math.max(5, Math.min(Integer.getInteger("profiler.cpu.art.stop.timeout.sec", 10), 300));
    static final double IMPORTED_TRACE_VIEW_EXPAND_PERCENTAGE = 0.1;
    private static final CaptureDetails.Type DEFAULT_CAPTURE_DETAILS = CaptureDetails.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final CpuKernelModel myCpuKernelModel;
    private final ClampedAxisComponentModel myCpuUsageAxis;
    private final ClampedAxisComponentModel myThreadCountAxis;
    private final ResizingAxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuProfilerConfigModel myProfilerConfigModel;
    private final CpuFramesModel myFramesModel;
    private final DurationDataModel<CpuTraceInfo> myRecentTraceDurations;
    @NotNull
    private final DurationDataModel<DefaultDurationData> myInProgressTraceDuration;
    @NotNull
    private final DefaultDataSeries<DefaultDurationData> myInProgressTraceSeries;
    private Cpu.TraceInitiationType myInProgressTraceInitiationType;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect = new AspectModel();
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private long myStopStartTimeNs;
    private CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    private final CpuCaptureStateUpdatable myCaptureStateUpdatable;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final TraceIdsIterator myTraceIdsIterator;
    private final boolean myIsImportTraceMode;
    @Nullable
    private File myImportedTrace;
    private Common.Session mySession;

    public CpuProfilerStage(@NotNull StudioProfilers profilers) {
        this(profilers, null);
    }

    public CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace) {
        this(profilers, importedTrace, new CpuCaptureParser(profilers.getIdeServices()));
    }

    @VisibleForTesting
    CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace, @NotNull CpuCaptureParser captureParser) {
        super(profilers);
        this.myImportedTrace = importedTrace;
        this.mySession = profilers.getSession();
        this.myIsImportTraceMode = this.getStudioProfilers().getIdeServices().getFeatureConfig().isImportCpuTraceEnabled() && importedTrace != null;
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myProfilerConfigModel = new CpuProfilerConfigModel(profilers, this);
        Range viewRange = this.getStudioProfilers().getTimeline().getViewRange();
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER).build();
        this.myThreadCountAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS).build();
        this.myTimeAxisGuide = new ResizingAxisComponentModel.Builder(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS).setGlobalRange(dataRange).build();
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, this, this.mySession);
        this.myCpuKernelModel = new CpuKernelModel(viewRange, this);
        this.myFramesModel = new CpuFramesModel(viewRange, this);
        this.myInProgressTraceSeries = new DefaultDataSeries();
        this.myInProgressTraceDuration = new DurationDataModel(new RangedSeries(viewRange, this.myInProgressTraceSeries));
        this.myInProgressTraceInitiationType = Cpu.TraceInitiationType.UNSPECIFIED_INITIATION;
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = this.buildSelectionModel(selectionRange);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myCaptureState = CaptureState.IDLE;
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.myCaptureStateUpdatable = new CpuCaptureStateUpdatable(() -> this.updateProfilingState(true));
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = captureParser;
        this.myTraceIdsIterator = new TraceIdsIterator(this, this.getTraceInfoFromRange(new Range(-1.7976931348623157E308, Double.MAX_VALUE)));
        this.myRecentTraceDurations = new DurationDataModel(new RangedSeries(new Range(-1.7976931348623157E308, Double.MAX_VALUE), (DataSeries)this.getCpuTraceDataSeries()));
        this.myRecentTraceDurations.addDependency((AspectObserver)this).onChange((Enum)DurationDataModel.Aspect.DURATION_DATA, () -> {
            Range xRange = this.myRecentTraceDurations.getSeries().getXRange();
            CpuTraceInfo candidateToSelect = null;
            List recentTraceInfo = this.myRecentTraceDurations.getSeries().getDataSeries().getDataForXRange(xRange);
            for (SeriesData series : recentTraceInfo) {
                CpuTraceInfo trace = (CpuTraceInfo)series.value;
                if (trace.getInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API) && !this.myTraceIdsIterator.contains(trace.getTraceId())) {
                    this.myTraceIdsIterator.addTrace(trace.getTraceId());
                    if (candidateToSelect == null || trace.getRange().getMax() > candidateToSelect.getRange().getMax()) {
                        candidateToSelect = trace;
                    }
                    this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuApiTracing(false, !trace.getTraceFilePath().isEmpty(), -1, -1, -1);
                }
                if (!(trace.getRange().getMax() > xRange.getMin())) continue;
                xRange.setMin(trace.getRange().getMax());
            }
            if (candidateToSelect != null) {
                this.setAndSelectCapture(candidateToSelect.getTraceId());
            }
        });
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    private SelectionModel buildSelectionModel(Range selectionRange) {
        SelectionModel selectionModel = new SelectionModel(selectionRange);
        selectionModel.addConstraint(this.myTraceDurations);
        if (this.myIsImportTraceMode) {
            selectionModel.addListener(new SelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                }

                public void selectionCleared() {
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }

                public void selectionCreationFailure() {
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }
            });
        } else {
            selectionModel.addListener(new SelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCleared() {
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCreationFailure() {
                    CpuProfilerStage.this.selectionChanged();
                }
            });
        }
        return selectionModel;
    }

    public boolean isImportTraceMode() {
        return this.myIsImportTraceMode;
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    @NotNull
    public DurationDataModel<DefaultDurationData> getInProgressTraceDuration() {
        return this.myInProgressTraceDuration;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public CpuProfilerConfigModel getProfilerConfigModel() {
        return this.myProfilerConfigModel;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register(this.myRecentTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuApiTracingEnabled()) {
            this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureStateUpdatable);
        }
        CodeNavigator navigator = this.getStudioProfilers().getIdeServices().getCodeNavigator();
        navigator.addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, this.myProfilerConfigModel::updateProfilingConfigurations);
        this.updateProfilingState(false);
        this.myProfilerConfigModel.updateProfilingConfigurations();
        if (this.myIsImportTraceMode) {
            assert (this.myImportedTrace != null);
            this.parseAndSelectImportedTrace(this.myImportedTrace);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuNewRecordingWorkflowEnabled()) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myRecentTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuApiTracingEnabled()) {
            this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureStateUpdatable);
        }
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.getStudioProfilers().removeDependencies(this);
        this.myCaptureParser.abortParsing();
        this.mySelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        return this.myUpdatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void toggleCapturing() {
        if (this.myCaptureState == CaptureState.CAPTURING) {
            this.stopCapturing();
        } else {
            this.startCapturing();
        }
    }

    public void startCapturing() {
        ProfilingConfiguration config = this.myProfilerConfigModel.getProfilingConfiguration();
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getCpuClient();
        assert (this.getStudioProfilers().getProcess() != null);
        CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setSession(this.mySession).setConfiguration(config.toProto()).setAbiCpuArch(this.getStudioProfilers().getProcess().getAbiCpuArch()).build();
        this.myInProgressTraceInitiationType = Cpu.TraceInitiationType.INITIATED_BY_UI;
        if (config.isDisableLiveAllocation()) {
            this.getStudioProfilers().setMemoryLiveAllocationEnabled(false);
        }
        this.setCaptureState(CaptureState.STARTING);
        CompletableFuture.supplyAsync(() -> cpuService.startProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> this.startCapturingCallback((CpuProfiler.CpuProfilingAppStartResponse)response, config), this.getStudioProfilers().getIdeServices().getMainExecutor());
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void startCapturingCallback(CpuProfiler.CpuProfilingAppStartResponse response, ProfilingConfiguration profilingConfiguration) {
        if (response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS)) {
            this.myProfilerConfigModel.setProfilingConfiguration(profilingConfiguration);
            this.setCaptureState(CaptureState.CAPTURING);
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            this.getStudioProfilers().getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_START_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
        }
    }

    public void stopCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getCpuClient();
        CpuProfiler.CpuProfilingAppStopRequest request = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setTraceType(this.myProfilerConfigModel.getProfilingConfiguration().getTraceType()).setTraceMode(this.myProfilerConfigModel.getProfilingConfiguration().getMode()).setSession(this.mySession).build();
        this.myInProgressTraceSeries.clear();
        long captureStartTimeUs = TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs);
        long currentTimeUs = TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs());
        this.myInProgressTraceSeries.add(captureStartTimeUs, (Object)new DefaultDurationData(currentTimeUs - captureStartTimeUs));
        this.setCaptureState(CaptureState.STOPPING);
        this.myStopStartTimeNs = System.nanoTime();
        CompletableFuture.supplyAsync(() -> cpuService.stopProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(this::stopCapturingCallback, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    public long getCaptureElapsedTimeUs() {
        return TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs() - this.myCaptureStartTimeNs);
    }

    private List<Cpu.CpuTraceInfo> getTraceInfoFromRange(Range rangeUs) {
        long rangeMinNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long rangeMaxNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        CpuProfiler.GetTraceInfoResponse response = this.getCpuClient().getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(this.mySession).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
        return response.getTraceInfoList();
    }

    @NotNull
    public TraceIdsIterator getTraceIdsIterator() {
        return this.myTraceIdsIterator;
    }

    void navigateNext() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.next());
    }

    void navigatePrevious() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.previous());
    }

    private void handleCaptureNavigation(long traceId) {
        if (traceId == -1L) {
            return;
        }
        this.setAndSelectCapture(traceId);
    }

    private void stopCapturingCallback(CpuProfiler.CpuProfilingAppStopResponse response) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerConfigModel.getProfilingConfiguration());
        long estimateDurationMs = TimeUnit.NANOSECONDS.toMillis(this.currentTimeNs() - this.myCaptureStartTimeNs);
        captureMetadata.setCaptureDurationMs(estimateDurationMs);
        int stopElapsedTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myStopStartTimeNs);
        captureMetadata.setStoppingTimeMs(stopElapsedTimeMs);
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS)) {
            CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_STOP_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.fromStopStatus(response.getStatus()));
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        } else {
            CompletableFuture.supplyAsync(() -> this.preProcessTrace(response.getTrace()), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(bytes -> {
                captureMetadata.setTraceFileSizeBytes(bytes.size());
                boolean failedToPreProcess = bytes.equals((Object)TracePreProcessor.FAILURE);
                if (failedToPreProcess) {
                    captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE);
                    this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.PREPROCESS_FAILURE);
                    this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
                    CpuProfilerStage.getLogger().warn("Unable to pre-process trace file.");
                    this.setCaptureState(CaptureState.IDLE);
                    this.setCapture(null);
                    return;
                }
                this.handleCaptureParsing(response.getTraceId(), (ByteString)bytes, captureMetadata);
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
        if (this.myProfilerConfigModel.getProfilingConfiguration().isDisableLiveAllocation()) {
            this.getStudioProfilers().setMemoryLiveAllocationEnabled(true);
        }
    }

    private boolean needsPreProcessTrace() {
        return this.getStudioProfilers().getIdeServices().getFeatureConfig().isSimpleperfHostEnabled() && this.myProfilerConfigModel.getProfilingConfiguration().getTraceType() == Cpu.CpuTraceType.SIMPLEPERF;
    }

    private ByteString preProcessTrace(ByteString trace) {
        if (this.needsPreProcessTrace()) {
            assert (this.myProfilerConfigModel.getProfilingConfiguration().getTraceType() == Cpu.CpuTraceType.SIMPLEPERF);
            return this.getStudioProfilers().getIdeServices().getSimpleperfTracePreProcessor().preProcessTrace(trace);
        }
        return trace;
    }

    @NotNull
    public CpuCaptureParser getCaptureParser() {
        return this.myCaptureParser;
    }

    private void parseAndSelectImportedTrace(@NotNull File traceFile) {
        assert (this.myIsImportTraceMode);
        this.myCaptureParser.updateParsingStateWhenStarting();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(traceFile);
        if (capture == null) {
            CpuProfilerStage.getLogger().info("Imported trace file was not parsed.");
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            if (parsedCapture != null) {
                ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
                Range captureRangeNs = new Range((double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMin()), (double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMax()));
                double expandAmountNs = 0.1 * captureRangeNs.getLength();
                timeline.reset((long)captureRangeNs.getMin(), (long)(captureRangeNs.getMax() + expandAmountNs));
                timeline.setIsPaused(true);
                this.myThreadsStates.buildImportedTraceThreads((CpuCapture)parsedCapture);
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                double expandAmountUs = TimeUnit.NANOSECONDS.toMicros((long)expandAmountNs);
                timeline.getViewRange().set(parsedCapture.getRange().getMin() - expandAmountUs, parsedCapture.getRange().getMax() + expandAmountUs);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                if (!this.myTraceIdsIterator.contains(42L)) {
                    this.saveTraceInfo(42L, (CpuCapture)parsedCapture, Cpu.CpuTraceMode.UNSPECIFIED_MODE, null);
                    this.myTraceIdsIterator.addTrace(42L);
                }
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackImportTrace(parsedCapture.getType(), true);
            } else if (capture.isCancelled()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_ABORTED);
            } else {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
                this.setCaptureState(CaptureState.IDLE);
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackImportTrace(Cpu.CpuTraceType.UNSPECIFIED_TYPE, false);
            }
        };
        capture.handleAsync((parsedCapture, exception) -> {
            parsingCallback.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private void handleCaptureParsing(long traceId, ByteString traceBytes, CpuCaptureMetadata captureMetadata) {
        long beforeParsingTime = System.currentTimeMillis();
        this.myCaptureParser.updateParsingStateWhenStarting();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.mySession, traceId, traceBytes, this.myProfilerConfigModel.getProfilingConfiguration().getTraceType());
        if (capture == null) {
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            this.myInProgressTraceSeries.clear();
            if (parsedCapture != null) {
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                ByteString preprocessedTraceBytes = null;
                if (this.needsPreProcessTrace()) {
                    preprocessedTraceBytes = traceBytes;
                }
                this.saveTraceInfo(traceId, (CpuCapture)parsedCapture, this.myProfilerConfigModel.getProfilingConfiguration().getMode(), preprocessedTraceBytes);
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                captureMetadata.setParsingTimeMs(System.currentTimeMillis() - beforeParsingTime);
                captureMetadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(parsedCapture.getDurationUs()));
                captureMetadata.setRecordDurationMs(CpuProfilerStage.calculateRecordDurationMs(parsedCapture));
            } else if (capture.isCancelled()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.PARSING_ABORTED);
            } else {
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                this.setCaptureState(CaptureState.IDLE);
                this.setCapture(null);
            }
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        };
        capture.handleAsync((parsedCapture, exception) -> {
            if (parsedCapture == null) {
                assert (exception != null);
                CpuProfilerStage.getLogger().warn("Unable to parse capture: " + exception.getMessage(), exception);
            }
            parsingCallback.accept((CpuCapture)parsedCapture);
            this.myTraceIdsIterator.addTrace(traceId);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private static long calculateRecordDurationMs(CpuCapture capture) {
        Range maxDataRange = new Range();
        for (CpuThreadInfo thread2 : capture.getThreads()) {
            CaptureNode threadMainNode = capture.getCaptureNode(thread2.getId());
            assert (threadMainNode != null);
            maxDataRange.expand((double)threadMainNode.getStartGlobal(), (double)threadMainNode.getEndGlobal());
        }
        return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
    }

    private void saveTraceInfo(long traceId, @NotNull CpuCapture capture, Cpu.CpuTraceMode mode, @Nullable ByteString preprocessedTrace) {
        long captureFrom = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin());
        long captureTo = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax());
        ArrayList threadIds = new ArrayList();
        capture.getThreads().forEach(thread2 -> threadIds.add(thread2.getId()));
        Cpu.CpuTraceInfo traceInfo = Cpu.CpuTraceInfo.newBuilder().setTraceId(traceId).setFromTimestamp(captureFrom).setToTimestamp(captureTo).setTraceType(capture.getType()).setTraceMode(mode).setTraceFilePath(Strings.nullToEmpty((String)this.myCaptureParser.getTraceFilePath(traceId))).addAllTids(threadIds).build();
        CpuProfiler.SaveTraceInfoRequest.Builder requestBuilder = CpuProfiler.SaveTraceInfoRequest.newBuilder().setSession(this.mySession).setTraceInfo(traceInfo);
        if (preprocessedTrace != null) {
            requestBuilder.setPreprocessedTrace(preprocessedTrace);
        }
        this.getCpuClient().saveTraceInfo(requestBuilder.build());
    }

    private CpuProfiler.ProfilingStateResponse checkProfilingState() {
        CpuProfiler.ProfilingStateRequest request = CpuProfiler.ProfilingStateRequest.newBuilder().setSession(this.mySession).build();
        return this.getCpuClient().checkAppProfilingState(request);
    }

    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
        return this.getStudioProfilers().getClient().getCpuClient();
    }

    @VisibleForTesting
    void updateProfilingState(boolean calledFromUpdatable) {
        CpuProfiler.ProfilingStateResponse response = this.checkProfilingState();
        if (response.getBeingProfiled()) {
            if (response.getInitiationType() != Cpu.TraceInitiationType.INITIATED_BY_API && calledFromUpdatable) {
                return;
            }
            ProfilingConfiguration configuration = ProfilingConfiguration.fromProto(response.getConfiguration());
            if (this.myCaptureState == CaptureState.IDLE) {
                if (response.getInitiationType() == Cpu.TraceInitiationType.INITIATED_BY_STARTUP) {
                    this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuStartupProfiling(configuration);
                }
                this.myInProgressTraceInitiationType = response.getInitiationType();
                this.setCaptureState(CaptureState.CAPTURING);
                this.myCaptureStartTimeNs = response.getStartTimestamp();
                this.myInProgressTraceSeries.clear();
                this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
                this.getStudioProfilers().getTimeline().setStreaming(true);
                if (this.myInProgressTraceInitiationType == Cpu.TraceInitiationType.INITIATED_BY_API) {
                    this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
                } else {
                    this.myProfilerConfigModel.setProfilingConfiguration(configuration);
                }
            }
        } else if (this.isApiInitiatedTracingInProgress()) {
            this.setCaptureState(CaptureState.IDLE);
            this.myInProgressTraceSeries.clear();
            this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
        }
    }

    private void selectionChanged() {
        CpuTraceInfo intersectingTraceInfo = this.getIntersectingTraceInfo(this.getStudioProfilers().getTimeline().getSelectionRange());
        if (intersectingTraceInfo == null) {
            this.setCapture(null);
        } else {
            this.setCapture(intersectingTraceInfo.getTraceId());
        }
    }

    @Nullable
    CpuTraceInfo getIntersectingTraceInfo(Range range) {
        List infoList = this.getTraceDurations().getSeries().getDataSeries().getDataForXRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (captureRange.getIntersection(range).isEmpty()) continue;
            return (CpuTraceInfo)info.value;
        }
        return null;
    }

    private long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax());
    }

    @VisibleForTesting
    public void setCapture(@Nullable CpuCapture capture) {
        if (!this.myCaptureModel.setCapture(capture)) {
            return;
        }
        if (capture != null) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
            this.onCaptureSelection();
        }
    }

    private void onCaptureSelection() {
        CpuCapture capture = this.getCapture();
        if (capture == null) {
            return;
        }
        if (this.getCaptureState() == CaptureState.IDLE || this.getCaptureState() == CaptureState.CAPTURING) {
            this.ensureCaptureInViewRange();
            if (capture.getType() == Cpu.CpuTraceType.ATRACE && !this.isImportTraceMode() && ((AtraceCpuCapture)capture).isMissingData()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.ATRACE_BUFFER_OVERFLOW);
            }
        }
    }

    private void ensureCaptureInViewRange() {
        CpuCapture capture = this.getCapture();
        assert (capture != null);
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        double padding = timeline.getViewRange().getLength() * 0.05;
        timeline.adjustRangeCloseToMiddleView(new Range(capture.getRange().getMin() - padding, capture.getRange().getMax() + padding));
    }

    private void setCapture(long traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.checkProfilingState().getBeingProfiled() ? CaptureState.CAPTURING : CaptureState.IDLE);
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(long traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.checkProfilingState().getBeingProfiled() ? CaptureState.CAPTURING : CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        timeline.getSelectionRange().set(capture.getRange());
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
        Range range = this.getStudioProfilers().getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        return ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
    }

    @NotNull
    public ClockType getClockType() {
        return this.myCaptureModel.getClockType();
    }

    public void setClockType(@NotNull ClockType clockType) {
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        return this.myCaptureState;
    }

    @NotNull
    public Cpu.TraceInitiationType getCaptureInitiationType() {
        return this.myInProgressTraceInitiationType;
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (!this.myCaptureState.equals((Object)captureState)) {
            this.myCaptureState = captureState;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
            if (captureState == CaptureState.CAPTURING) {
                this.setProfilerMode(ProfilerMode.EXPANDED);
            }
        }
    }

    public void setCaptureFilter(@NotNull Filter filter) {
        this.myCaptureModel.setFilter(filter);
        this.trackFilterUsage(filter);
    }

    @NotNull
    public Filter getCaptureFilter() {
        return this.myCaptureModel.getFilter();
    }

    public int getCaptureFilterNodeCount() {
        return this.myCaptureModel.getFilterNodeCount();
    }

    private void trackFilterUsage(@NotNull Filter filter) {
        CaptureDetails details = this.getCaptureDetails();
        if (details == null) {
            return;
        }
        FilterMetadata filterMetadata = new FilterMetadata();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        switch (details.getType()) {
            case TOP_DOWN: {
                filterMetadata.setView(FilterMetadata.View.CPU_TOP_DOWN);
                break;
            }
            case BOTTOM_UP: {
                filterMetadata.setView(FilterMetadata.View.CPU_BOTTOM_UP);
                break;
            }
            case CALL_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_CALL_CHART);
                break;
            }
            case FLAME_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_FLAME_CHART);
            }
        }
        filterMetadata.setFeaturesUsed(filter.isMatchCase(), filter.isRegex());
        filterMetadata.setMatchedElementCount(this.myCaptureModel.getFilterNodeCount());
        filterMetadata.setTotalElementCount(this.myCaptureModel.getNodeCount());
        filterMetadata.setFilterTextLength(filter.isEmpty() ? 0 : filter.getFilterString().length());
        featureTracker.trackFilterMetadata(filterMetadata);
    }

    public boolean isApiInitiatedTracingInProgress() {
        return this.myCaptureState == CaptureState.CAPTURING && this.getCaptureInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        return this.myCpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        return this.myThreadsStates;
    }

    @NotNull
    public CpuKernelModel getCpuKernelModel() {
        return this.myCpuKernelModel;
    }

    @NotNull
    public CpuFramesModel getFramesModel() {
        return this.myFramesModel;
    }

    @VisibleForTesting
    @Nullable
    CompletableFuture<CpuCapture> getCaptureFuture(long traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            this.myCaptureParser.updateParsingStateWhenStarting();
            this.setProfilerMode(ProfilerMode.EXPANDED);
            CpuProfiler.GetTraceRequest request = CpuProfiler.GetTraceRequest.newBuilder().setSession(this.mySession).setTraceId(traceId).build();
            CpuProfiler.GetTraceResponse trace = this.getCpuClient().getTrace(request);
            if (trace.getStatus() == CpuProfiler.GetTraceResponse.Status.SUCCESS) {
                capture = this.myCaptureParser.parse(this.mySession, traceId, trace.getData(), trace.getTraceType());
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureDetails.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureDetails getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            super(dataRange);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            return this.myCpuLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            return this.myOthersLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            return this.myThreadsLegend;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForXRange(Range xRange) {
            List traceInfo = CpuProfilerStage.this.getTraceInfoFromRange(xRange);
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (Cpu.CpuTraceInfo protoTraceInfo : traceInfo) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    @VisibleForTesting
    static class CpuCaptureStateUpdatable
    implements Updatable {
        @NotNull
        private final Runnable myCallback;
        @VisibleForTesting
        static final int UPDATE_COUNT_TO_CALL_CALLBACK = 6;
        private int myUpdateCount = 0;

        public CpuCaptureStateUpdatable(@NotNull Runnable callback) {
            this.myCallback = callback;
        }

        public void update(long elapsedNs) {
            if (this.myUpdateCount++ >= 6) {
                this.myCallback.run();
                this.myUpdateCount = 0;
            }
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.myCaptureState == CaptureState.CAPTURING || CpuProfilerStage.this.myCaptureParser.isParsing()) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        STARTING,
        STOPPING;

    }

    public static enum ThreadState {
        RUNNING,
        RUNNING_CAPTURED,
        SLEEPING,
        SLEEPING_CAPTURED,
        DEAD,
        DEAD_CAPTURED,
        WAITING,
        WAITING_CAPTURED,
        HAS_ACTIVITY,
        NO_ACTIVITY,
        RUNNABLE_CAPTURED,
        WAITING_IO_CAPTURED,
        UNKNOWN;

    }
}

