/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuThreadCountDataSeries
implements DataSeries<Long> {
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;

    public CpuThreadCountDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid) {
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
    }

    public List<SeriesData<Long>> getDataForXRange(Range xRangeUs) {
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)xRangeUs.getMin());
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(Common.Event.Kind.CPU_THREAD).build();
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(request);
        TreeMap<Long, Long> timestampToCountMap = new TreeMap<Long, Long>();
        for (Transport.EventGroup group : response.getGroupsList()) {
            if (group.getEventsCount() <= 0) continue;
            Common.Event first = group.getEvents(0);
            Common.Event last = group.getEvents(group.getEventsCount() - 1);
            if (last.getTimestamp() < minNs && last.getIsEnded()) continue;
            Long count = (Long)timestampToCountMap.get(first.getTimestamp());
            timestampToCountMap.put(first.getTimestamp(), count == null ? 1L : count + 1L);
            if (!last.getIsEnded()) continue;
            count = (Long)timestampToCountMap.get(last.getTimestamp());
            timestampToCountMap.put(last.getTimestamp(), count == null ? -1L : count - 1L);
        }
        ArrayList<SeriesData<Long>> data = new ArrayList<SeriesData<Long>>();
        long total = 0L;
        for (Map.Entry entry : timestampToCountMap.entrySet()) {
            data.add((SeriesData<Long>)new SeriesData(TimeUnit.NANOSECONDS.toMicros((Long)entry.getKey()), (Object)(total += ((Long)entry.getValue()).longValue())));
        }
        if (timestampToCountMap.isEmpty()) {
            data.add(new SeriesData((long)xRangeUs.getMin(), (Object)total));
            data.add((SeriesData<Long>)new SeriesData((long)xRangeUs.getMax(), (Object)total));
        } else if ((double)((SeriesData)data.get((int)(data.size() - 1))).x < xRangeUs.getMax()) {
            data.add((SeriesData<Long>)new SeriesData((long)xRangeUs.getMax(), (Object)total));
        }
        return data;
    }
}

