/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuThreadStateDataSeries
implements DataSeries<CpuProfilerStage.ThreadState> {
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;
    private final int myThreadId;

    public CpuThreadStateDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid, int threadId) {
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
        this.myThreadId = threadId;
    }

    public List<SeriesData<CpuProfilerStage.ThreadState>> getDataForXRange(Range xRangeUs) {
        ArrayList<SeriesData<CpuProfilerStage.ThreadState>> series = new ArrayList<SeriesData<CpuProfilerStage.ThreadState>>();
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)xRangeUs.getMax());
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(Common.Event.Kind.CPU_THREAD).setGroupId((long)this.myThreadId).setToTimestamp(maxNs).build());
        assert (response.getGroupsCount() <= 1);
        if (response.getGroupsCount() == 1) {
            for (Common.Event event : response.getGroups(0).getEventsList()) {
                series.add((SeriesData<CpuProfilerStage.ThreadState>)new SeriesData(TimeUnit.NANOSECONDS.toMicros(event.getTimestamp()), (Object)CpuThreadsModel.getState(event.getCpuThread().getState(), false)));
            }
        }
        return series;
    }
}

