/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Cpu;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuTraceInfo
implements ConfigurableDurationData {
    @NotNull
    private final Cpu.CpuTraceInfo myInfo;
    @NotNull
    private final Range myRange;

    public CpuTraceInfo(Cpu.CpuTraceInfo traceInfo) {
        this.myInfo = traceInfo;
        this.myRange = new Range((double)TimeUnit.NANOSECONDS.toMicros(traceInfo.getFromTimestamp()), (double)TimeUnit.NANOSECONDS.toMicros(traceInfo.getToTimestamp()));
    }

    @NotNull
    public Cpu.CpuTraceInfo getTraceInfo() {
        return this.myInfo;
    }

    public long getDurationUs() {
        return (long)this.myRange.getLength();
    }

    @NotNull
    public Range getRange() {
        return this.myRange;
    }

    public long getTraceId() {
        return this.myInfo.getTraceId();
    }

    @NotNull
    public String getTraceFilePath() {
        return this.myInfo.getTraceFilePath();
    }

    @NotNull
    public Cpu.CpuTraceType getTraceType() {
        return this.myInfo.getTraceType();
    }

    @NotNull
    public Cpu.TraceInitiationType getInitiationType() {
        return this.myInfo.getInitiationType();
    }

    public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    public boolean canSelectPartialRange() {
        return true;
    }
}

