/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.cpu.CpuUsageDataSeries;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CpuUsage
extends LineChartModel {
    @NotNull
    private final Range myCpuRange = new Range(0.0, 100.0);
    @NotNull
    private final RangedContinuousSeries myCpuSeries;

    public CpuUsage(@NotNull StudioProfilers profilers) {
        Object series = profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled() ? new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), profilers.getSession().getStreamId(), profilers.getSession().getPid(), Common.Event.Kind.CPU_USAGE, profilers.getSession().getPid(), events -> CpuUsage.extractData(events.stream().map(event -> event.getCpuUsage()).collect(Collectors.toList()), false)) : new CpuUsageDataSeries(profilers.getClient().getCpuClient(), profilers.getSession(), dataList -> CpuUsage.extractData(dataList, false));
        this.myCpuSeries = new RangedContinuousSeries(this.getCpuSeriesLabel(), profilers.getTimeline().getViewRange(), this.myCpuRange, (DataSeries)series);
        this.add(this.myCpuSeries);
    }

    @NotNull
    public Range getCpuRange() {
        return this.myCpuRange;
    }

    @NotNull
    public RangedContinuousSeries getCpuSeries() {
        return this.myCpuSeries;
    }

    protected String getCpuSeriesLabel() {
        return "";
    }

    public static Stream<SeriesData<Long>> extractData(List<Cpu.CpuUsageData> dataList, boolean isOtherProcess) {
        return IntStream.range(0, dataList.size()).filter(index -> index > 0).mapToObj(index -> CpuUsage.getCpuUsageData(dataList, index, isOtherProcess));
    }

    private static SeriesData<Long> getCpuUsageData(List<Cpu.CpuUsageData> dataList, int index, boolean isOtherProcess) {
        Cpu.CpuUsageData data = dataList.get(index);
        Cpu.CpuUsageData lastData = dataList.get(index - 1);
        long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
        long elapsed = data.getElapsedTimeInMillisec() - lastData.getElapsedTimeInMillisec();
        double app = 100.0 * (double)(data.getAppCpuTimeInMillisec() - lastData.getAppCpuTimeInMillisec()) / (double)elapsed;
        double system = 100.0 * (double)(data.getSystemCpuTimeInMillisec() - lastData.getSystemCpuTimeInMillisec()) / (double)elapsed;
        system = Math.max(0.0, Math.min(system, 100.0));
        app = Math.max(0.0, Math.min(app, system));
        return new SeriesData(dataTimestamp, (Object)((long)(isOtherProcess ? system - app : app)));
    }
}

