/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CpuUsageDataSeries
implements DataSeries<Long> {
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myClient;
    private final Common.Session mySession;
    private final Function<List<Cpu.CpuUsageData>, Stream<SeriesData<Long>>> myDataExtractor;

    public CpuUsageDataSeries(@NotNull CpuServiceGrpc.CpuServiceBlockingStub client, Common.Session session, Function<List<Cpu.CpuUsageData>, Stream<SeriesData<Long>>> dataExtractor) {
        this.myClient = client;
        this.mySession = session;
        this.myDataExtractor = dataExtractor;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        CpuProfiler.CpuDataRequest.Builder dataRequestBuilder = CpuProfiler.CpuDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        CpuProfiler.CpuDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        return this.myDataExtractor.apply(response.getDataList()).collect(Collectors.toList());
    }
}

