/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.CpuUsageTooltip;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class CpuUsageTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuUsageTooltip myTooltip;
    @NotNull
    private final CpuProfilerStageView myView;
    @NotNull
    private final JLabel mySelectionLabel;

    CpuUsageTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuUsageTooltip tooltip) {
        super(view.getTimeline());
        this.myTooltip = tooltip;
        this.myView = view;
        this.mySelectionLabel = new JLabel();
    }

    @Override
    protected void updateTooltip() {
        boolean canSelect = ((CpuProfilerStage)this.myView.getStage()).getSelectionModel().canSelectRange(this.myView.getTimeline().getTooltipRange());
        if (canSelect) {
            List traceSeries = ((CpuProfilerStage)this.myView.getStage()).getTraceDurations().getSeries().getDataSeries().getDataForXRange(this.myView.getTimeline().getTooltipRange());
            if (traceSeries.isEmpty()) {
                return;
            }
            SeriesData trace = (SeriesData)traceSeries.get(0);
            String name = ProfilingTechnology.fromTypeAndMode(((CpuTraceInfo)trace.value).getTraceType(), ((CpuTraceInfo)trace.value).getTraceInfo().getTraceMode()).getName();
            this.mySelectionLabel.setText(name);
        } else {
            this.mySelectionLabel.setText("Selection Unavailable");
        }
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit"));
        JPanel detailsPanel = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit-"));
        CpuProfilerStage.CpuStageLegends legends = this.myTooltip.getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        legend.setForeground(ProfilerColors.TOOLTIP_TEXT);
        legend.configure((Legend)legends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_USAGE_CAPTURED));
        legend.configure((Legend)legends.getOthersLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_OTHER_USAGE_CAPTURED));
        legend.configure((Legend)legends.getThreadsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.THREADS_COUNT_CAPTURED));
        panel.add((Component)legend, new TabularLayout.Constraint(0, 0));
        JSeparator separator = new JSeparator(0);
        separator.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        detailsPanel.add((Component)separator, new TabularLayout.Constraint(0, 0));
        this.mySelectionLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        this.mySelectionLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        detailsPanel.add((Component)this.mySelectionLabel, new TabularLayout.Constraint(1, 0));
        panel.add((Component)detailsPanel, new TabularLayout.Constraint(1, 0));
        return panel;
    }
}

