/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LegacyCpuThreadStateDataSeries
implements DataSeries<CpuProfilerStage.ThreadState> {
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;
    private final int myThreadId;

    public LegacyCpuThreadStateDataSeries(@NotNull CpuServiceGrpc.CpuServiceBlockingStub client, @NotNull Common.Session session, int tid) {
        this.myClient = client;
        this.mySession = session;
        this.myThreadId = tid;
    }

    public List<SeriesData<CpuProfilerStage.ThreadState>> getDataForXRange(Range xRange) {
        ArrayList<SeriesData<CpuProfilerStage.ThreadState>> data = new ArrayList<SeriesData<CpuProfilerStage.ThreadState>>();
        long min = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin());
        long max = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax());
        CpuProfiler.GetThreadsResponse threads = this.myClient.getThreads(CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(min).setEndTimestamp(max).build());
        CpuProfiler.GetTraceInfoResponse traces = this.myClient.getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(this.mySession).setFromTimestamp(min).setToTimestamp(max).build());
        for (CpuProfiler.GetThreadsResponse.Thread thread2 : threads.getThreadsList()) {
            if (thread2.getTid() != this.myThreadId) continue;
            ArrayList<Double> captureTimes = new ArrayList<Double>(traces.getTraceInfoCount() * 2);
            for (Cpu.CpuTraceInfo traceInfo : traces.getTraceInfoList()) {
                if (!traceInfo.getTidsList().contains(this.myThreadId)) continue;
                captureTimes.add(Double.valueOf(TimeUnit.NANOSECONDS.toMicros(traceInfo.getFromTimestamp())));
                captureTimes.add(Double.valueOf(TimeUnit.NANOSECONDS.toMicros(traceInfo.getToTimestamp())));
            }
            List list = thread2.getActivitiesList();
            int i = 0;
            int j = 0;
            boolean inCapture = false;
            Cpu.CpuThreadData.State state = Cpu.CpuThreadData.State.UNSPECIFIED;
            while (i < list.size()) {
                long time;
                long captureTime;
                CpuProfiler.GetThreadsResponse.ThreadActivity activity = (CpuProfiler.GetThreadsResponse.ThreadActivity)list.get(i);
                long timestamp = TimeUnit.NANOSECONDS.toMicros(activity.getTimestamp());
                long l = captureTime = j < captureTimes.size() ? ((Double)captureTimes.get(j)).longValue() : Long.MAX_VALUE;
                if (captureTime < timestamp) {
                    inCapture = !inCapture;
                    time = captureTime;
                    ++j;
                } else {
                    state = activity.getNewState();
                    time = timestamp;
                    ++i;
                }
                if (state == Cpu.CpuThreadData.State.UNSPECIFIED) continue;
                data.add((SeriesData<CpuProfilerStage.ThreadState>)new SeriesData(time, (Object)CpuThreadsModel.getState(state, inCapture)));
            }
            while (j < captureTimes.size()) {
                inCapture = !inCapture;
                data.add((SeriesData<CpuProfilerStage.ThreadState>)new SeriesData(((Double)captureTimes.get(j)).longValue(), (Object)CpuThreadsModel.getState(state, inCapture)));
                ++j;
            }
        }
        return data;
    }
}

