/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MergeCaptureDataSeries<T>
implements DataSeries<T> {
    @NotNull
    private final DataSeries<T> myDataStoreSeries;
    @NotNull
    private AtraceDataSeries<T> myAtraceDataSeries;
    @NotNull
    private final CpuProfilerStage myStage;

    public MergeCaptureDataSeries(@NotNull CpuProfilerStage stage, @NotNull DataSeries<T> dataStoreSeries, @NotNull AtraceDataSeries traceState) {
        this.myStage = stage;
        this.myAtraceDataSeries = traceState;
        this.myDataStoreSeries = dataStoreSeries;
    }

    public List<SeriesData<T>> getDataForXRange(Range xRange) {
        Range traceRange;
        double minRangeUs = xRange.getMin();
        double maxRangeUs = xRange.getMax();
        ArrayList<SeriesData<T>> seriesData = new ArrayList<SeriesData<T>>();
        if (this.myStage.getCapture() instanceof AtraceCpuCapture && (traceRange = this.myStage.getCapture().getRange()).getMin() <= maxRangeUs && traceRange.getMax() >= minRangeUs) {
            List<SeriesData<T>> atraceSeries;
            double traceStart = traceRange.getMin() < minRangeUs ? minRangeUs : traceRange.getMin();
            double atraceSeriesRequestTo = traceRange.getMax();
            if (traceRange.getMax() > maxRangeUs) {
                atraceSeriesRequestTo = maxRangeUs;
            }
            double firstAtraceSeriesEntryTime = !(atraceSeries = this.getDataForRangeFromSeries(traceStart, atraceSeriesRequestTo, this.myAtraceDataSeries)).isEmpty() ? (double)atraceSeries.get((int)0).x : atraceSeriesRequestTo;
            List<SeriesData<T>> dataStoreSeries = this.getDataForRangeFromSeries(minRangeUs, firstAtraceSeriesEntryTime, this.myDataStoreSeries);
            minRangeUs = atraceSeriesRequestTo;
            int dataStoreSeriesIndex = dataStoreSeries.size();
            if (!atraceSeries.isEmpty()) {
                while (--dataStoreSeriesIndex >= 0 && dataStoreSeries.get((int)dataStoreSeriesIndex).x > atraceSeries.get((int)0).x) {
                }
                ++dataStoreSeriesIndex;
            }
            seriesData.addAll(dataStoreSeries.subList(0, dataStoreSeriesIndex));
            seriesData.addAll(atraceSeries);
        }
        if (minRangeUs < maxRangeUs) {
            seriesData.addAll(this.getDataForRangeFromSeries(minRangeUs, maxRangeUs, this.myDataStoreSeries));
        }
        return seriesData;
    }

    private List<SeriesData<T>> getDataForRangeFromSeries(double minUs, double maxUs, DataSeries<T> series) {
        Range range = new Range(minUs, maxUs);
        return series.getDataForXRange(range);
    }
}

