/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.utils.HashCodes;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ProfilingConfiguration {
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    private String myName;
    private Cpu.CpuTraceType myProfilerType;
    private Cpu.CpuTraceMode myMode;
    private int myProfilingBufferSizeInMb = 8;
    private int myProfilingSamplingIntervalUs = 1000;
    private boolean myDisableLiveAllocation = true;

    public ProfilingConfiguration() {
    }

    public ProfilingConfiguration(String name, Cpu.CpuTraceType profilerType, Cpu.CpuTraceMode mode) {
        this.myName = name;
        this.myProfilerType = profilerType;
        this.myMode = mode;
    }

    public Cpu.CpuTraceMode getMode() {
        return this.myMode;
    }

    public void setMode(Cpu.CpuTraceMode mode) {
        this.myMode = mode;
    }

    public Cpu.CpuTraceType getTraceType() {
        return this.myProfilerType;
    }

    public void setTraceType(Cpu.CpuTraceType traceType) {
        this.myProfilerType = traceType;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public int getProfilingBufferSizeInMb() {
        return this.myProfilingBufferSizeInMb;
    }

    public void setProfilingBufferSizeInMb(int profilingBufferSizeInMb) {
        this.myProfilingBufferSizeInMb = profilingBufferSizeInMb;
    }

    public int getProfilingSamplingIntervalUs() {
        return this.myProfilingSamplingIntervalUs;
    }

    public boolean isDisableLiveAllocation() {
        return this.myDisableLiveAllocation;
    }

    public void setDisableLiveAllocation(boolean disableLiveAllocation) {
        this.myDisableLiveAllocation = disableLiveAllocation;
    }

    public int getRequiredDeviceLevel() {
        switch (this.myProfilerType) {
            case ATRACE: {
                return 24;
            }
            case SIMPLEPERF: {
                return 26;
            }
        }
        return 0;
    }

    public boolean isDeviceLevelSupported(int deviceLevel) {
        return deviceLevel >= this.getRequiredDeviceLevel();
    }

    public void setProfilingSamplingIntervalUs(int profilingSamplingIntervalUs) {
        this.myProfilingSamplingIntervalUs = profilingSamplingIntervalUs;
    }

    @NotNull
    public static ProfilingConfiguration fromProto(@NotNull CpuProfiler.CpuProfilerConfiguration proto) {
        ProfilingConfiguration configuration = new ProfilingConfiguration(proto.getName(), proto.getTraceType(), proto.getTraceMode());
        configuration.setProfilingSamplingIntervalUs(proto.getSamplingIntervalUs());
        configuration.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
        configuration.setDisableLiveAllocation(proto.getDisableLiveAllocation());
        return configuration;
    }

    @NotNull
    public CpuProfiler.CpuProfilerConfiguration toProto() {
        return CpuProfiler.CpuProfilerConfiguration.newBuilder().setName(this.getName()).setTraceType(this.getTraceType()).setTraceMode(this.getMode()).setSamplingIntervalUs(this.getProfilingSamplingIntervalUs()).setBufferSizeInMb(this.getProfilingBufferSizeInMb()).setDisableLiveAllocation(this.isDisableLiveAllocation()).build();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProfilingConfiguration)) {
            return false;
        }
        ProfilingConfiguration incoming = (ProfilingConfiguration)obj;
        return StringUtil.equals((CharSequence)this.getName(), (CharSequence)incoming.getName()) && this.getTraceType() == incoming.getTraceType() && this.getMode() == incoming.getMode() && this.getProfilingSamplingIntervalUs() == incoming.getProfilingSamplingIntervalUs() && this.getProfilingBufferSizeInMb() == incoming.getProfilingBufferSizeInMb() && this.isDisableLiveAllocation() == incoming.isDisableLiveAllocation();
    }

    public int hashCode() {
        return HashCodes.mix((int)Objects.hashCode(this.getName()), (int)Objects.hashCode(this.getTraceType()), (int)Objects.hashCode(this.getMode()), (int)this.getProfilingSamplingIntervalUs(), (int)this.getProfilingBufferSizeInMb(), (int)Boolean.hashCode(this.isDisableLiveAllocation()));
    }
}

