/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import org.jetbrains.annotations.NotNull;

public enum ProfilingTechnology {
    ART_SAMPLED("Java Method Sample Recording", "Samples Java code using Android Runtime."),
    ART_INSTRUMENTED("Java Method Trace Recording", "Instruments Java code using Android Runtime."),
    ART_UNSPECIFIED("Java Method Recording", "Profiles Java code using Android Runtime."),
    SIMPLEPERF("C/C++ Function Recording", "Samples native code using simpleperf.", "Available for Android 8.0 (API level 26) and higher."),
    ATRACE("System Trace Recording", "Traces Java and native code at the Android platform level.", "Available for Android 8.0 (API level 26) and higher.");

    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    @NotNull
    private final String myExtraDescription;

    private ProfilingTechnology(@NotNull String name, String description, String extraDescription) {
        this.myName = name;
        this.myDescription = description;
        this.myExtraDescription = extraDescription;
    }

    private ProfilingTechnology(String name, String description) {
        this(name, description, "");
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public String getLongDescription() {
        return String.format("<html>%s %s</html>", this.myDescription, this.myExtraDescription);
    }

    @NotNull
    public Cpu.CpuTraceType getType() {
        switch (this) {
            case ART_SAMPLED: {
                return Cpu.CpuTraceType.ART;
            }
            case ART_INSTRUMENTED: {
                return Cpu.CpuTraceType.ART;
            }
            case ART_UNSPECIFIED: {
                return Cpu.CpuTraceType.ART;
            }
            case SIMPLEPERF: {
                return Cpu.CpuTraceType.SIMPLEPERF;
            }
            case ATRACE: {
                return Cpu.CpuTraceType.ATRACE;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public Cpu.CpuTraceMode getMode() {
        switch (this) {
            case ART_SAMPLED: {
                return Cpu.CpuTraceMode.SAMPLED;
            }
            case ART_INSTRUMENTED: {
                return Cpu.CpuTraceMode.INSTRUMENTED;
            }
            case ART_UNSPECIFIED: {
                return Cpu.CpuTraceMode.UNSPECIFIED_MODE;
            }
            case SIMPLEPERF: {
                return Cpu.CpuTraceMode.SAMPLED;
            }
            case ATRACE: {
                return Cpu.CpuTraceMode.INSTRUMENTED;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public static ProfilingTechnology fromTypeAndMode(@NotNull Cpu.CpuTraceType type, @NotNull Cpu.CpuTraceMode mode) {
        switch (type) {
            case ART: {
                if (mode == Cpu.CpuTraceMode.SAMPLED) {
                    return ART_SAMPLED;
                }
                if (mode == Cpu.CpuTraceMode.INSTRUMENTED) {
                    return ART_INSTRUMENTED;
                }
                return ART_UNSPECIFIED;
            }
            case SIMPLEPERF: {
                return SIMPLEPERF;
            }
            case ATRACE: {
                return ATRACE;
            }
        }
        throw new IllegalStateException("Error while trying to get the name of an unknown profiling configuration");
    }

    @NotNull
    public static ProfilingTechnology fromConfig(@NotNull ProfilingConfiguration config) {
        return ProfilingTechnology.fromTypeAndMode(config.getTraceType(), config.getMode());
    }
}

