/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.AtraceFrameFilterConfig;
import com.android.tools.profilers.cpu.atrace.AtraceParser;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AtraceCpuCapture
extends CpuCapture {
    private final AtraceParser myParser;

    public AtraceCpuCapture(AtraceParser parser, long traceId) {
        super(parser, traceId, Cpu.CpuTraceType.ATRACE);
        this.myParser = parser;
    }

    @NotNull
    public List<SeriesData<CpuProfilerStage.ThreadState>> getThreadStatesForThread(int threadId) {
        return this.myParser.getThreadStateDataSeries().getOrDefault(threadId, new ArrayList());
    }

    @NotNull
    public List<SeriesData<CpuThreadSliceInfo>> getCpuThreadSliceInfoStates(int cpu) {
        return this.myParser.getCpuThreadSliceInfoStates().getOrDefault(cpu, new ArrayList());
    }

    @NotNull
    public List<SeriesData<Long>> getCpuUtilizationSeries() {
        return this.myParser.getCpuUtilizationSeries();
    }

    public int getCpuCount() {
        return this.myParser.getCpuThreadSliceInfoStates().size();
    }

    public boolean isMissingData() {
        return this.myParser.isMissingData();
    }

    public List<SeriesData<AtraceFrame>> getFrames(AtraceFrameFilterConfig filter) {
        return this.myParser.getFrames(filter);
    }

    public int getRenderThreadId() {
        return this.myParser.getRenderThreadId();
    }
}

