/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.profilers.cpu.atrace.AtraceProducer;
import com.android.tools.profilers.cpu.atrace.PerfettoProducer;
import com.android.tools.profilers.cpu.atrace.TrebuchetBufferProducer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;

public final class AtraceExporter {
    public static void export(@NotNull File file, @NotNull OutputStream output) throws IOException {
        TrebuchetBufferProducer buffer;
        if (AtraceProducer.verifyFileHasAtraceHeader(file)) {
            buffer = new AtraceProducer();
        } else if (PerfettoProducer.verifyFileHasPerfettoTraceHeader(file)) {
            buffer = new PerfettoProducer();
        } else {
            throw new IOException("Unable to verify file type for export: " + file.getAbsolutePath());
        }
        if (!buffer.parseFile(file)) {
            throw new IOException("Failed to parse file for export: " + file.getAbsolutePath());
        }
        try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(output);){
            DataSlice line = buffer.next();
            output.write(AtraceProducer.HEADER.toByteArray());
            while ((line = buffer.next()) != null) {
                deflaterOutputStream.write(line.getBuffer());
            }
            deflaterOutputStream.flush();
        }
        catch (IOException ex) {
            throw new IOException("Failed to export atrace file.", ex);
        }
    }
}

