/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.event.EventAction;
import com.intellij.util.Function;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.base.SliceGroup;

public class AtraceFrame
extends EventAction<PerfClass>
implements DurationData {
    private static final double SECONDS_TO_US = TimeUnit.SECONDS.toMicros(1L);
    public static final AtraceFrame EMPTY = new AtraceFrame(0, (Function<Double, Long>)((Function)t -> 0L), 0L, FrameThread.OTHER);
    private AtraceFrame myAssociatedFrame;
    @NotNull
    private final Range myTotalRangeSeconds = new Range();
    @NotNull
    private final Function<Double, Long> myBootClockSecondsToMonoUs;
    private double myCpuTimeSeconds;
    private final long myLongFrameTimeUs;
    @NotNull
    private PerfClass myPerfClass;
    private final int myThreadId;
    private final FrameThread myThread;

    public AtraceFrame(int threadId, @NotNull Function<Double, Long> bootClockSecondsToMonoUs, long longFrameTimeUs, FrameThread thread2) {
        super(0L, 0L, (Object)PerfClass.NOT_SET);
        this.myBootClockSecondsToMonoUs = bootClockSecondsToMonoUs;
        this.myLongFrameTimeUs = longFrameTimeUs;
        this.myThreadId = threadId;
        this.myPerfClass = PerfClass.NOT_SET;
        this.myThread = thread2;
    }

    public FrameThread getThread() {
        return this.myThread;
    }

    public void setAssociatedFrame(AtraceFrame associatedFrame) {
        this.myAssociatedFrame = associatedFrame;
    }

    public AtraceFrame getAssociatedFrame() {
        return this.myAssociatedFrame;
    }

    @NotNull
    public PerfClass getPerfClass() {
        return this.myPerfClass;
    }

    public PerfClass getTotalPerfClass() {
        double associatedFrameLength;
        if (this.myPerfClass == PerfClass.NOT_SET) {
            return PerfClass.NOT_SET;
        }
        double d = associatedFrameLength = this.myAssociatedFrame == null ? 0.0 : this.myAssociatedFrame.getTotalRangeSeconds().getLength();
        if (SECONDS_TO_US * (associatedFrameLength + this.myTotalRangeSeconds.getLength()) > (double)this.myLongFrameTimeUs) {
            return PerfClass.BAD;
        }
        return PerfClass.GOOD;
    }

    public long getDurationUs() {
        return (long)(SECONDS_TO_US * this.getTotalRangeSeconds().getLength());
    }

    public long getStartUs() {
        return (Long)this.myBootClockSecondsToMonoUs.fun((Object)this.myTotalRangeSeconds.getMin());
    }

    public long getEndUs() {
        return (Long)this.myBootClockSecondsToMonoUs.fun((Object)this.myTotalRangeSeconds.getMax());
    }

    public double getCpuTimeSeconds() {
        return this.myCpuTimeSeconds;
    }

    @NotNull
    public PerfClass getType() {
        return this.getPerfClass();
    }

    @NotNull
    public Range getTotalRangeSeconds() {
        return this.myTotalRangeSeconds;
    }

    public int getThreadId() {
        return this.myThreadId;
    }

    public void addSlice(@NotNull SliceGroup sliceGroup, @NotNull Range range) {
        this.myTotalRangeSeconds.setMin(Math.min(this.myTotalRangeSeconds.getMin(), range.getMin()));
        this.myTotalRangeSeconds.setMax(Math.max(this.myTotalRangeSeconds.getMax(), range.getMax()));
        this.myCpuTimeSeconds += sliceGroup.getCpuTime();
        this.myPerfClass = SECONDS_TO_US * this.myTotalRangeSeconds.getLength() > (double)this.myLongFrameTimeUs ? PerfClass.BAD : PerfClass.GOOD;
    }

    public static enum FrameThread {
        MAIN,
        RENDER,
        OTHER;

    }

    public static enum PerfClass {
        NOT_SET,
        GOOD,
        BAD;

    }
}

