/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuFramesModel;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.AtraceFrameFilterConfig;
import com.android.tools.profilers.cpu.atrace.SliceStream;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.ProcessModel;
import trebuchet.model.ThreadModel;
import trebuchet.model.base.SliceGroup;

public class AtraceFrameManager {
    @NotNull
    private final Function<Double, Long> myBootClockSecondsToMonoUs;
    @NotNull
    private final ProcessModel myProcessModel;
    private final int myRenderThreadId;
    private final List<AtraceFrame> myMainThreadFrames;
    private final List<AtraceFrame> myRenderThreadFrames;

    public AtraceFrameManager(@NotNull ProcessModel process, @NotNull Function<Double, Long> bootClockSecondsToMonoUs, int renderThreadId) {
        this.myBootClockSecondsToMonoUs = bootClockSecondsToMonoUs;
        this.myProcessModel = process;
        this.myRenderThreadId = renderThreadId;
        this.myMainThreadFrames = this.getFramesList("Choreographer#doFrame", this.myProcessModel.getId(), CpuFramesModel.SLOW_FRAME_RATE_US, AtraceFrame.FrameThread.MAIN);
        this.myRenderThreadFrames = this.getFramesList("(DrawFrame|doFrame|queueBuffer)", this.myRenderThreadId, CpuFramesModel.SLOW_FRAME_RATE_US, AtraceFrame.FrameThread.RENDER);
        this.findAssociatedFrames();
    }

    private void findAssociatedFrames() {
        int mainFramesIterator = 0;
        int renderFramesIterator = 0;
        while (mainFramesIterator < this.myMainThreadFrames.size() && renderFramesIterator < this.myRenderThreadFrames.size()) {
            AtraceFrame mainThreadFrame = this.myMainThreadFrames.get(mainFramesIterator);
            AtraceFrame renderThreadFrame = this.myRenderThreadFrames.get(renderFramesIterator);
            if (renderThreadFrame == AtraceFrame.EMPTY || renderThreadFrame.getEndUs() < mainThreadFrame.getEndUs()) {
                ++renderFramesIterator;
                continue;
            }
            if (mainThreadFrame == AtraceFrame.EMPTY || renderThreadFrame.getStartUs() > mainThreadFrame.getEndUs() || renderThreadFrame.getStartUs() < mainThreadFrame.getStartUs()) {
                ++mainFramesIterator;
                continue;
            }
            mainThreadFrame.setAssociatedFrame(renderThreadFrame);
            renderThreadFrame.setAssociatedFrame(mainThreadFrame);
            ++mainFramesIterator;
            ++renderFramesIterator;
        }
    }

    @NotNull
    private List<AtraceFrame> getFramesList(String identifierRegEx, int threadId, long longFrameTimingUs, AtraceFrame.FrameThread frameThread) {
        ArrayList<AtraceFrame> frames = new ArrayList<AtraceFrame>();
        Optional<ThreadModel> activeThread = this.myProcessModel.getThreads().stream().filter(thread2 -> thread2.getId() == threadId).findFirst();
        if (!activeThread.isPresent()) {
            return frames;
        }
        new SliceStream(activeThread.get().getSlices()).matchPattern(Pattern.compile(identifierRegEx)).enumerate(sliceGroup -> {
            AtraceFrame frame = new AtraceFrame(((ThreadModel)activeThread.get()).getId(), this.myBootClockSecondsToMonoUs, longFrameTimingUs, frameThread);
            double startTime = sliceGroup.getStartTime();
            double endTime = sliceGroup.getEndTime();
            frame.addSlice((SliceGroup)sliceGroup, new Range(startTime, endTime));
            frames.add(frame);
            return SliceStream.EnumerationResult.SKIP_CHILDREN;
        });
        return frames;
    }

    @NotNull
    public List<AtraceFrame> buildFramesList(@NotNull AtraceFrameFilterConfig filter) {
        if (filter.getThreadId() == this.myProcessModel.getId() && filter.getIdentifierRegEx() == "Choreographer#doFrame" && filter.getLongFrameTimingUs() == CpuFramesModel.SLOW_FRAME_RATE_US) {
            return this.myMainThreadFrames;
        }
        if (filter.getThreadId() == this.myRenderThreadId && filter.getIdentifierRegEx() == "(DrawFrame|doFrame|queueBuffer)" && filter.getLongFrameTimingUs() == CpuFramesModel.SLOW_FRAME_RATE_US) {
            return this.myRenderThreadFrames;
        }
        return this.getFramesList(filter.getIdentifierRegEx(), filter.getThreadId(), filter.getLongFrameTimingUs(), filter.getThreadId() == this.myProcessModel.getId() ? AtraceFrame.FrameThread.MAIN : (filter.getThreadId() == this.myRenderThreadId ? AtraceFrame.FrameThread.RENDER : AtraceFrame.FrameThread.OTHER));
    }
}

