/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuFrameTooltip
extends AspectModel<Aspect>
implements ProfilerTooltip {
    @NotNull
    private final CpuProfilerStage myStage;
    @Nullable
    private DataSeries<AtraceFrame> mySeries;
    @Nullable
    private AtraceFrame myFrame;

    public CpuFrameTooltip(@NotNull CpuProfilerStage stage) {
        this.myStage = stage;
        Range tooltipRange = stage.getStudioProfilers().getTimeline().getTooltipRange();
        tooltipRange.addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateState);
    }

    @Override
    public void dispose() {
        this.myStage.getStudioProfilers().getTimeline().getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private void updateState() {
        this.myFrame = null;
        if (this.mySeries == null) {
            this.changed(Aspect.FRAME_CHANGED);
            return;
        }
        Range tooltipRange = this.myStage.getStudioProfilers().getTimeline().getTooltipRange();
        List series = this.mySeries.getDataForXRange(tooltipRange);
        this.myFrame = series.isEmpty() ? null : (AtraceFrame)((Object)((SeriesData)series.get((int)0)).value);
        this.changed(Aspect.FRAME_CHANGED);
    }

    public void setFrameSeries(@Nullable DataSeries<AtraceFrame> stateSeries) {
        this.mySeries = stateSeries;
        this.updateState();
    }

    @Nullable
    public AtraceFrame getFrame() {
        return this.myFrame;
    }

    public static enum Aspect {
        FRAME_CHANGED;

    }
}

