/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuKernelTooltip
extends AspectModel<Aspect>
implements ProfilerTooltip {
    @NotNull
    private final CpuProfilerStage myStage;
    @Nullable
    private DataSeries<CpuThreadSliceInfo> mySeries;
    @Nullable
    private CpuThreadSliceInfo myCpuThreadSliceInfo;
    private int myCpuId;

    public CpuKernelTooltip(@NotNull CpuProfilerStage stage) {
        this.myStage = stage;
        Range tooltipRange = stage.getStudioProfilers().getTimeline().getTooltipRange();
        tooltipRange.addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateState);
    }

    @Override
    public void dispose() {
        this.myStage.getStudioProfilers().getTimeline().getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private void updateState() {
        this.myCpuThreadSliceInfo = null;
        if (this.mySeries == null) {
            this.changed(Aspect.CPU_KERNEL_THREAD_SLICE_INFO);
            return;
        }
        Range tooltipRange = this.myStage.getStudioProfilers().getTimeline().getTooltipRange();
        List series = this.mySeries.getDataForXRange(tooltipRange);
        CpuThreadSliceInfo cpuThreadSliceInfo = this.myCpuThreadSliceInfo = series.isEmpty() ? null : (CpuThreadSliceInfo)((SeriesData)series.get((int)0)).value;
        if (this.myCpuThreadSliceInfo == CpuThreadSliceInfo.NULL_THREAD) {
            this.myCpuThreadSliceInfo = null;
        }
        this.changed(Aspect.CPU_KERNEL_THREAD_SLICE_INFO);
    }

    public void setCpuSeries(int cpuId, @Nullable DataSeries<CpuThreadSliceInfo> stateSeries) {
        this.mySeries = stateSeries;
        this.myCpuId = cpuId;
        this.updateState();
    }

    @Nullable
    public CpuThreadSliceInfo getCpuThreadSliceInfo() {
        return this.myCpuThreadSliceInfo;
    }

    public int getCpuId() {
        return this.myCpuId;
    }

    public static enum Aspect {
        CPU_KERNEL_THREAD_SLICE_INFO;

    }
}

