/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.profiler.protobuf3jarjar.CodedInputStream;
import com.android.tools.profiler.protobuf3jarjar.ExtensionRegistryLite;
import com.android.tools.profilers.cpu.atrace.PerfettoPacketDBSorter;
import com.android.tools.profilers.cpu.atrace.TrebuchetBufferProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.PerfettoTrace;
import trebuchet.io.DataSlice;

public class PerfettoProducer
implements TrebuchetBufferProducer {
    private static final String FTRACE_HEADER = "# tracer: nop";
    private static final Predicate<PerfettoTrace.FtraceEvent> IS_SUPPORTED_EVENT = event -> event.hasSchedSwitch() || event.hasSchedWakeup() || event.hasSchedWaking() || event.hasPrint();
    private final Map<Integer, Integer> myTidToTgid = new HashMap<Integer, Integer>();
    private final Map<Integer, String> myTidToName = new HashMap<Integer, String>();
    private final ArrayDeque<String> myGeneratedTrebuchetLines = new ArrayDeque();
    private final PerfettoPacketDBSorter mySorter = new PerfettoPacketDBSorter();

    private static double NanosToSeconds(double nanos) {
        return nanos / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    private static double NanosToMillis(double nanos) {
        return nanos / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public static boolean verifyFileHasPerfettoTraceHeader(@NotNull File file) {
        try {
            CodedInputStream inputStream = CodedInputStream.newInstance((InputStream)new FileInputStream(file));
            ExtensionRegistryLite packetRegistry = ExtensionRegistryLite.newInstance();
            PerfettoTrace.registerAllExtensions((ExtensionRegistryLite)packetRegistry);
            PerfettoTrace.TracePacket packet = PerfettoProducer.readOnePacket(inputStream, packetRegistry);
            return packet != null;
        }
        catch (IOException ex) {
            PerfettoProducer.getLogger().error((Throwable)ex);
            return false;
        }
    }

    private static PerfettoTrace.TracePacket readOnePacket(CodedInputStream stream, ExtensionRegistryLite packetRegistry) {
        try {
            stream.resetSizeCounter();
            int tag = stream.readTag();
            if (tag == 0) {
                return null;
            }
            if (tag != 10) {
                PerfettoProducer.getLogger().error(String.format("Encounted unknown tag (%d) when attempting to parse perfetto capture.", tag));
                return null;
            }
            return (PerfettoTrace.TracePacket)stream.readMessage(PerfettoTrace.TracePacket.parser(), packetRegistry);
        }
        catch (IOException ex) {
            PerfettoProducer.getLogger().error((Throwable)ex);
            return null;
        }
    }

    private static Logger getLogger() {
        return Logger.getInstance(PerfettoProducer.class);
    }

    @Override
    public boolean parseFile(File file) {
        try {
            this.convertToTraceLines(file);
            return true;
        }
        catch (IOException ex) {
            PerfettoProducer.getLogger().error((Throwable)ex);
            return false;
        }
    }

    private void convertToTraceLines(File file) throws IOException {
        PerfettoTrace.FtraceEventBundle bundle;
        PerfettoTrace.TracePacket packet;
        this.myTidToName.put(0, "<idle>");
        PerfettoTrace.TracePacket clockSyncPacket = null;
        ExtensionRegistryLite packetRegistry = ExtensionRegistryLite.newInstance();
        PerfettoTrace.registerAllExtensions((ExtensionRegistryLite)packetRegistry);
        CodedInputStream inputStream = CodedInputStream.newInstance((InputStream)new FileInputStream(file));
        while ((packet = PerfettoProducer.readOnePacket(inputStream, packetRegistry)) != null) {
            if (packet.hasFtraceEvents()) {
                bundle = packet.getFtraceEvents();
                for (PerfettoTrace.FtraceEvent event : bundle.getEventList()) {
                    if (!event.hasSchedSwitch()) continue;
                    PerfettoTrace.SchedSwitchFtraceEvent schedSwitch = event.getSchedSwitch();
                    this.myTidToName.putIfAbsent(schedSwitch.getPrevPid(), schedSwitch.getPrevComm());
                    this.myTidToName.putIfAbsent(schedSwitch.getNextPid(), schedSwitch.getNextComm());
                }
                continue;
            }
            if (packet.hasProcessTree()) {
                PerfettoTrace.ProcessTree processTree = packet.getProcessTree();
                for (PerfettoTrace.ProcessTree.Process process : processTree.getProcessesList()) {
                    this.myTidToTgid.putIfAbsent(process.getPid(), process.getPid());
                }
                for (PerfettoTrace.ProcessTree.Thread thread2 : processTree.getThreadsList()) {
                    this.myTidToTgid.putIfAbsent(thread2.getTid(), thread2.getTgid());
                    if (!thread2.hasName()) continue;
                    this.myTidToName.putIfAbsent(thread2.getTid(), thread2.getName());
                }
                continue;
            }
            if (!packet.hasClockSnapshot() || clockSyncPacket != null) continue;
            clockSyncPacket = packet;
        }
        inputStream = CodedInputStream.newInstance((InputStream)new FileInputStream(file));
        while ((packet = PerfettoProducer.readOnePacket(inputStream, packetRegistry)) != null) {
            if (!packet.hasFtraceEvents()) continue;
            bundle = packet.getFtraceEvents();
            for (PerfettoTrace.FtraceEvent event : bundle.getEventList()) {
                if (!IS_SUPPORTED_EVENT.apply((Object)event)) continue;
                this.mySorter.addLine(event.getTimestamp(), this.formatLine(event, bundle.getCpu()));
            }
        }
        this.myGeneratedTrebuchetLines.add("# Initial Data Required by Importer");
        this.myGeneratedTrebuchetLines.add(FTRACE_HEADER);
        assert (clockSyncPacket != null);
        this.addClockSyncLines(clockSyncPacket);
        this.mySorter.resetForIterator();
    }

    private void addClockSyncLines(@NotNull PerfettoTrace.TracePacket clockSyncPacket) {
        PerfettoTrace.ClockSnapshot snapshot = clockSyncPacket.getClockSnapshot();
        PerfettoTrace.ClockSnapshot.Clock monotonicClock = null;
        PerfettoTrace.ClockSnapshot.Clock realtimeClock = null;
        PerfettoTrace.ClockSnapshot.Clock boottimeClock = null;
        for (PerfettoTrace.ClockSnapshot.Clock clock : snapshot.getClocksList()) {
            if (clock.getType() == PerfettoTrace.ClockSnapshot.Clock.Type.MONOTONIC) {
                monotonicClock = clock;
                continue;
            }
            if (clock.getType() == PerfettoTrace.ClockSnapshot.Clock.Type.REALTIME) {
                realtimeClock = clock;
                continue;
            }
            if (clock.getType() != PerfettoTrace.ClockSnapshot.Clock.Type.BOOTTIME) continue;
            boottimeClock = clock;
        }
        assert (monotonicClock != null && realtimeClock != null);
        this.myGeneratedTrebuchetLines.add(this.formatEventPrefix(boottimeClock.getTimestamp(), 0, Short.MAX_VALUE) + String.format("tracing_mark_write: trace_event_clock_sync: parent_ts=%.6f", PerfettoProducer.NanosToSeconds(monotonicClock.getTimestamp())));
        this.myGeneratedTrebuchetLines.add(this.formatEventPrefix(boottimeClock.getTimestamp(), 0, Short.MAX_VALUE) + "tracing_mark_write: trace_event_clock_sync: realtime_ts=" + PerfettoProducer.NanosToMillis(realtimeClock.getTimestamp()));
    }

    @Override
    @Nullable
    public DataSlice next() {
        if (!this.mySorter.hasNext()) {
            return null;
        }
        String line = !this.myGeneratedTrebuchetLines.isEmpty() ? this.myGeneratedTrebuchetLines.poll() : this.mySorter.next();
        byte[] data = String.format("%s\n", line.substring(0, Math.min(1022, line.length()))).getBytes();
        return new DataSlice(data);
    }

    @Override
    public void close() {
        this.myTidToName.clear();
        this.myTidToTgid.clear();
    }

    private String formatLine(PerfettoTrace.FtraceEvent event, int cpu) {
        return this.formatEventPrefix(event.getTimestamp(), cpu, event.getPid()) + PerfettoProducer.formatEvent(event);
    }

    private String formatEventPrefix(long timestampNs, int cpu, int pid) {
        String name = this.myTidToName.getOrDefault(pid, "<...>");
        String timeSeconds = String.format("%.6f", PerfettoProducer.NanosToSeconds(timestampNs));
        String tgid = "-----";
        if (this.myTidToTgid.containsKey(pid)) {
            tgid = String.format("%5d", this.myTidToTgid.get(pid));
        }
        return String.format("%s-%d     (%s) [%3d] d..3 %s: ", name, pid, tgid, cpu, timeSeconds);
    }

    private static String formatEvent(PerfettoTrace.FtraceEvent event) {
        if (event.hasSchedSwitch()) {
            PerfettoTrace.SchedSwitchFtraceEvent sched = event.getSchedSwitch();
            return String.format("sched_switch: prev_comm=%s prev_pid=%d prev_prio=%d prev_state=%s ==> next_comm=%s next_pid=%d next_prio=%d", sched.getPrevComm(), sched.getPrevPid(), sched.getPrevPrio(), sched.getPrevState(), sched.getNextComm(), sched.getNextPid(), sched.getNextPrio());
        }
        if (event.hasSchedCpuHotplug()) {
            PerfettoTrace.SchedCpuHotplugFtraceEvent sched = event.getSchedCpuHotplug();
            return String.format("sched_cpu_hotplug: cpu %d %s error=%d", sched.getAffectedCpu(), sched.getStatus() == 0 ? "offline" : "online", sched.getError());
        }
        if (event.hasSchedBlockedReason()) {
            PerfettoTrace.SchedBlockedReasonFtraceEvent sched = event.getSchedBlockedReason();
            return String.format("sched_blocked_reason: pid=%d iowait=%d caller=%s", sched.getPid(), sched.getIoWait(), sched.getCaller());
        }
        if (event.hasSchedWaking()) {
            PerfettoTrace.SchedWakingFtraceEvent sched = event.getSchedWaking();
            return String.format("sched_wakeing: comm=%s pid=%d prio=%d success=%d target_cpu=%03d", sched.getComm(), sched.getPid(), sched.getPrio(), sched.getSuccess(), sched.getTargetCpu());
        }
        if (event.hasSchedWakeup()) {
            PerfettoTrace.SchedWakeupFtraceEvent sched = event.getSchedWakeup();
            return String.format("sched_wakeup: comm=%s pid=%d prio=%d success=%d target_cpu=%03d", sched.getComm(), sched.getPid(), sched.getPrio(), sched.getSuccess(), sched.getTargetCpu());
        }
        if (event.hasPrint()) {
            return String.format("tracing_mark_write: %s", event.getPrint().getBuf().replace("\n", ""));
        }
        PerfettoProducer.getLogger().assertTrue(IS_SUPPORTED_EVENT.apply((Object)event), (Object)"Attempted to format a non-supported event.");
        return "";
    }
}

