/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.base.SliceGroup;

public final class SliceStream {
    @NotNull
    private final List<SliceGroup> mySlices;
    private Pattern myPattern = Pattern.compile(".*");
    private Range myRange = new Range(Double.MIN_VALUE, Double.MAX_VALUE);

    public SliceStream(@NotNull List<SliceGroup> slices) {
        this.mySlices = slices;
    }

    public SliceStream matchPattern(@NotNull Pattern pattern) {
        this.myPattern = pattern;
        return this;
    }

    public SliceStream matchName(@NotNull String name) {
        return this.matchPattern(Pattern.compile("^" + Pattern.quote(name) + ""));
    }

    public SliceStream overlapsRange(Range range) {
        this.myRange = range;
        return this;
    }

    public void enumerate(@NotNull Function<SliceGroup, EnumerationResult> action) {
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, action);
    }

    public SliceGroup findFirst() {
        SliceGroup[] slices = new SliceGroup[1];
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, sliceGroup -> {
            slices[0] = sliceGroup;
            return EnumerationResult.TERMINATE;
        });
        return slices[0];
    }

    private static EnumerationResult forEachMatchingSlice(@NotNull List<SliceGroup> sliceGroups, @NotNull Pattern pattern, @NotNull Range range, Function<SliceGroup, EnumerationResult> action) {
        for (SliceGroup slice : sliceGroups) {
            EnumerationResult result;
            if (!(slice.getStartTime() <= range.getMax()) || !(slice.getEndTime() >= range.getMin())) continue;
            boolean skipChildren = false;
            if (pattern.matcher(slice.getName()).matches()) {
                EnumerationResult continueResult = action.apply(slice);
                if (continueResult == EnumerationResult.TERMINATE) {
                    return continueResult;
                }
                boolean bl = skipChildren = continueResult == EnumerationResult.SKIP_CHILDREN;
            }
            if (skipChildren || (result = SliceStream.forEachMatchingSlice(slice.getChildren(), pattern, range, action)) != EnumerationResult.TERMINATE) continue;
            return result;
        }
        return EnumerationResult.CONTINUE;
    }

    public static enum EnumerationResult {
        CONTINUE,
        TERMINATE,
        SKIP_CHILDREN;

    }
}

