/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.EnumColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.AtraceNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class AtraceNodeModelHChartColors {
    private static EnumColors<CpuProfilerStage.ThreadState> threadColors = ProfilerColors.THREAD_STATES.build();

    AtraceNodeModelHChartColors() {
    }

    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (!(model instanceof AtraceNodeModel)) {
            throw new IllegalStateException("Model must be an instance of AtraceNodeModel.");
        }
    }

    static Color getIdleCpuColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused) {
        Color color;
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            threadColors.setColorIndex(isFocused ? 1 : 0);
            color = threadColors.getColor((Enum)CpuProfilerStage.ThreadState.RUNNABLE_CAPTURED);
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER_IDLE : ProfilerColors.CPU_FLAMECHART_APP_IDLE;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused) {
        Color color;
        AtraceNodeModelHChartColors.validateModel(model);
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            threadColors.setColorIndex(isFocused ? 1 : 0);
            color = threadColors.getColor((Enum)CpuProfilerStage.ThreadState.RUNNING_CAPTURED);
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER : ProfilerColors.CPU_FLAMECHART_APP;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }
}

