/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpTreeModel;
import com.android.tools.profilers.cpu.capturedetails.TopDownNode;
import com.android.tools.profilers.cpu.capturedetails.TopDownTreeModel;
import java.util.ArrayList;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CaptureDetails {
    public Type getType();

    public static class FlameChart
    implements ChartDetails {
        @NotNull
        private final Range myFlameRange;
        @Nullable
        private CaptureNode myFlameNode;
        @Nullable
        private final TopDownNode myTopDownNode;
        @NotNull
        private final Range mySelectionRange;
        @NotNull
        private final AspectModel<Aspect> myAspectModel;

        public FlameChart(@NotNull Range selectionRange, @Nullable CaptureNode captureNode) {
            this.mySelectionRange = selectionRange;
            this.myFlameRange = new Range();
            this.myAspectModel = new AspectModel();
            if (captureNode == null) {
                this.myFlameNode = null;
                this.myTopDownNode = null;
                return;
            }
            this.myTopDownNode = new TopDownNode(captureNode);
            selectionRange.addDependency(this.myAspectModel).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeChanged);
            this.selectionRangeChanged();
        }

        private void selectionRangeChanged() {
            assert (this.myTopDownNode != null);
            this.myTopDownNode.update(this.mySelectionRange);
            if (this.myTopDownNode.getGlobalTotal() > 0.0) {
                double start = Math.max((double)this.myTopDownNode.getNodes().get(0).getStart(), this.mySelectionRange.getMin());
                this.myFlameNode = this.convertToFlameChart(this.myTopDownNode, start, 0);
            } else {
                this.myFlameNode = null;
            }
            this.myFlameRange.set(this.mySelectionRange);
            this.myAspectModel.changed((Enum)Aspect.NODE);
        }

        @NotNull
        public Range getRange() {
            return this.myFlameRange;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myFlameNode;
        }

        @NotNull
        public AspectModel<Aspect> getAspect() {
            return this.myAspectModel;
        }

        @Override
        public Type getType() {
            return Type.FLAME_CHART;
        }

        private CaptureNode convertToFlameChart(@NotNull TopDownNode topDown, double start, int depth) {
            assert (topDown.getGlobalTotal() > 0.0);
            CaptureNode node = new CaptureNode(topDown.getNodes().get(0).getData());
            node.setFilterType(topDown.getNodes().get(0).getFilterType());
            node.setStartGlobal((long)start);
            node.setStartThread((long)start);
            node.setEndGlobal((long)(start + topDown.getGlobalTotal()));
            node.setEndThread((long)(start + topDown.getThreadTotal()));
            node.setDepth(depth);
            for (TopDownNode child : topDown.getChildren()) {
                child.update(this.mySelectionRange);
            }
            ArrayList sortedChildren = new ArrayList(topDown.getChildren());
            sortedChildren.sort((o1, o2) -> {
                int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
                return cmp == 0 ? Double.compare(o2.getGlobalTotal(), o1.getGlobalTotal()) : cmp;
            });
            for (TopDownNode child : sortedChildren) {
                if (child.getGlobalTotal() == 0.0) continue;
                node.addChild(this.convertToFlameChart(child, start, depth + 1));
                start += child.getGlobalTotal();
            }
            return node;
        }

        public static enum Aspect {
            NODE;

        }
    }

    public static class CallChart
    implements ChartDetails {
        @NotNull
        private final Range myRange;
        @Nullable
        private CaptureNode myNode;

        public CallChart(@NotNull Range range, @Nullable CaptureNode node) {
            this.myRange = range;
            this.myNode = node;
        }

        @NotNull
        public Range getRange() {
            return this.myRange;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myNode;
        }

        @Override
        public Type getType() {
            return Type.CALL_CHART;
        }
    }

    public static class BottomUp
    implements CaptureDetails {
        @Nullable
        private BottomUpTreeModel myModel;

        public BottomUp(@NotNull Range range, @Nullable CaptureNode node) {
            this.myModel = node == null ? null : new BottomUpTreeModel(range, new BottomUpNode(node));
        }

        @Nullable
        public BottomUpTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Type getType() {
            return Type.BOTTOM_UP;
        }
    }

    public static class TopDown
    implements CaptureDetails {
        @Nullable
        private final TopDownTreeModel myModel;

        public TopDown(@NotNull Range range, @Nullable CaptureNode node) {
            this.myModel = node == null ? null : new TopDownTreeModel(range, new TopDownNode(node));
        }

        @Nullable
        public TopDownTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Type getType() {
            return Type.TOP_DOWN;
        }
    }

    public static interface ChartDetails
    extends CaptureDetails {
        @Nullable
        public CaptureNode getNode();
    }

    public static enum Type {
        TOP_DOWN(TopDown::new),
        BOTTOM_UP(BottomUp::new),
        CALL_CHART(CallChart::new),
        FLAME_CHART(FlameChart::new);

        @NotNull
        private final BiFunction<Range, CaptureNode, CaptureDetails> myBuilder;

        private Type(BiFunction<Range, CaptureNode, CaptureDetails> builder) {
            this.myBuilder = builder;
        }

        public CaptureDetails build(Range range, CaptureNode node) {
            return this.myBuilder.apply(range, node);
        }
    }
}

