/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.RangeTimeScrollBar;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.HTreeChartVerticalScrollBar;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.capturedetails.CpuChartTooltipView;
import com.android.tools.profilers.cpu.capturedetails.CpuTraceEventTooltipView;
import com.android.tools.profilers.cpu.nodemodel.AtraceNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.intellij.ui.DoubleClickListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ChartDetailsView
extends CaptureDetailsView {
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    protected final CpuProfilerStageView myStageView;
    @NotNull
    protected final AspectObserver myObserver;

    private ChartDetailsView(@NotNull CpuProfilerStageView stageView, @NotNull CaptureDetails.ChartDetails chartDetails) {
        this.myStageView = stageView;
        this.myObserver = new AspectObserver();
        if (chartDetails.getNode() == null) {
            this.myPanel = ChartDetailsView.getNoDataForThread();
            return;
        }
        this.myPanel = new JPanel(new CardLayout());
        this.myPanel.add((Component)ChartDetailsView.getNoDataForRange(), "Empty content");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    protected HTreeChart<CaptureNode> createChart(@NotNull CaptureDetails.ChartDetails chartDetails, @NotNull Range globalRange, @NotNull Range range) {
        CaptureDetails.Type type = chartDetails.getType();
        CaptureNode node = chartDetails.getNode();
        HTreeChart.Orientation orientation = type == CaptureDetails.Type.CALL_CHART ? HTreeChart.Orientation.TOP_DOWN : HTreeChart.Orientation.BOTTOM_UP;
        HTreeChart chart = new HTreeChart.Builder((HNode)node, range, (HRenderer)new CaptureNodeHRenderer(type)).setGlobalXRange(globalRange).setOrientation(orientation).setRootVisible(false).build();
        if (node != null) {
            if (node.getData() instanceof AtraceNodeModel) {
                if (type == CaptureDetails.Type.CALL_CHART) {
                    chart.addMouseMotionListener((MouseMotionListener)new CpuTraceEventTooltipView((HTreeChart<CaptureNode>)chart, this.myStageView, ProfilerColors.CPU_USAGE_CAPTURED, ProfilerColors.CPU_TRACE_IDLE));
                } else {
                    chart.addMouseMotionListener((MouseMotionListener)new CpuTraceEventTooltipView((HTreeChart<CaptureNode>)chart, this.myStageView, ProfilerColors.CPU_FLAMECHART_APP, ProfilerColors.CPU_FLAMECHART_APP_IDLE));
                }
            } else {
                chart.addMouseMotionListener((MouseMotionListener)new CpuChartTooltipView((HTreeChart<CaptureNode>)chart, this.myStageView));
            }
        }
        if (((CpuProfilerStage)this.myStageView.getStage()).getCapture() != null && ((CpuProfilerStage)this.myStageView.getStage()).getCapture().getType() != Cpu.CpuTraceType.ATRACE) {
            CodeNavigator navigator = ((CpuProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getCodeNavigator();
            CodeNavigationHandler handler = new CodeNavigationHandler((HTreeChart<CaptureNode>)chart, navigator);
            chart.addMouseListener((MouseListener)handler);
            this.myStageView.getIdeComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart, navigator, () -> handler.getCodeLocation());
        }
        return chart;
    }

    @Nullable
    protected static CodeLocation modelToCodeLocation(CaptureNodeModel model) {
        if (model instanceof CppFunctionModel) {
            CppFunctionModel nativeFunction = (CppFunctionModel)model;
            return new CodeLocation.Builder(nativeFunction.getClassOrNamespace()).setMethodName(nativeFunction.getName()).setMethodParameters(nativeFunction.getParameters()).setNativeCode(true).setFileName(nativeFunction.getFileName()).setNativeVAddress(nativeFunction.getVAddress()).build();
        }
        if (model instanceof JavaMethodModel) {
            JavaMethodModel javaMethod = (JavaMethodModel)model;
            return new CodeLocation.Builder(javaMethod.getClassName()).setMethodName(javaMethod.getName()).setMethodSignature(javaMethod.getSignature()).setNativeCode(false).build();
        }
        return null;
    }

    private static class CodeNavigationHandler
    extends MouseAdapter {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        private Point myLastPopupPoint;

        CodeNavigationHandler(@NotNull HTreeChart<CaptureNode> chart, final @NotNull CodeNavigator navigator) {
            this.myChart = chart;
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent event) {
                    this.setLastPopupPoint(event);
                    CodeLocation codeLocation = this.getCodeLocation();
                    if (codeLocation != null) {
                        navigator.navigate(codeLocation);
                    }
                    return false;
                }
            }.installOn(chart);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.setLastPopupPoint(e);
            }
        }

        private void setLastPopupPoint(MouseEvent e) {
            this.myLastPopupPoint = e.getPoint();
        }

        @Nullable
        private CodeLocation getCodeLocation() {
            CaptureNode n = (CaptureNode)this.myChart.getNodeAt(this.myLastPopupPoint);
            if (n == null) {
                return null;
            }
            return ChartDetailsView.modelToCodeLocation(n.getData());
        }
    }

    static final class FlameChartDetailsView
    extends ChartDetailsView {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        @NotNull
        private final CaptureDetails.FlameChart myFlameChart;
        @NotNull
        private final Range myMasterRange;

        FlameChartDetailsView(CpuProfilerStageView stageView, @NotNull CaptureDetails.FlameChart flameChart) {
            super(stageView, flameChart);
            this.myFlameChart = flameChart;
            this.myMasterRange = new Range(flameChart.getRange());
            this.myChart = this.createChart(flameChart, flameChart.getRange(), this.myMasterRange);
            if (this.myFlameChart.getNode() == null) {
                return;
            }
            this.myPanel.add((Component)this.createChartPanel(), "Content");
            this.myFlameChart.getAspect().addDependency(this.myObserver).onChange((Enum)CaptureDetails.FlameChart.Aspect.NODE, this::nodeChanged);
            this.nodeChanged();
        }

        @NotNull
        private JPanel createChartPanel() {
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(this.myFlameChart.getRange(), this.myMasterRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
            panel.add((Component)this.myChart, new TabularLayout.Constraint(0, 0));
            panel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), new TabularLayout.Constraint(0, 1));
            panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
            return panel;
        }

        private void nodeChanged() {
            FlameChartDetailsView.switchCardLayout(this.myPanel, this.myFlameChart.getNode() == null);
            this.myChart.setHTree((HNode)this.myFlameChart.getNode());
            this.myMasterRange.set(this.myFlameChart.getRange());
        }
    }

    static final class CallChartDetailsView
    extends ChartDetailsView {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        @NotNull
        private final CaptureDetails.CallChart myCallChart;

        CallChartDetailsView(@NotNull CpuProfilerStageView stageView, @NotNull CaptureDetails.CallChart callChart) {
            super(stageView, callChart);
            this.myCallChart = callChart;
            assert (((CpuProfilerStage)stageView.getStage()).getCapture() != null);
            this.myChart = this.createChart(this.myCallChart, ((CpuProfilerStage)stageView.getStage()).getCapture().getRange(), stageView.getTimeline().getSelectionRange());
            if (this.myCallChart.getNode() == null) {
                return;
            }
            this.myPanel.add((Component)this.createChartPanel(), "Content");
            this.myCallChart.getRange().addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::callChartRangeChanged);
            this.callChartRangeChanged();
        }

        @NotNull
        private JPanel createChartPanel() {
            Range selectionRange = this.myStageView.getTimeline().getSelectionRange();
            assert (((CpuProfilerStage)this.myStageView.getStage()).getCapture() != null);
            Range captureRange = ((CpuProfilerStage)this.myStageView.getStage()).getCapture().getRange();
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(captureRange, selectionRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            AxisComponent axis = CallChartDetailsView.createAxis(selectionRange, this.myStageView.getTimeline().getDataRange());
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
            panel.add((Component)axis, new TabularLayout.Constraint(0, 0));
            panel.add((Component)this.myChart, new TabularLayout.Constraint(0, 0));
            panel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), new TabularLayout.Constraint(0, 1));
            panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
            return panel;
        }

        private void callChartRangeChanged() {
            CaptureNode node = this.myCallChart.getNode();
            assert (node != null);
            Range intersection = this.myCallChart.getRange().getIntersection(new Range((double)node.getStart(), (double)node.getEnd()));
            CallChartDetailsView.switchCardLayout(this.myPanel, intersection.isEmpty() || intersection.getLength() == 0.0);
        }

        private static AxisComponent createAxis(@NotNull Range range, @NotNull Range globalRange) {
            ResizingAxisComponentModel axisModel = new ResizingAxisComponentModel.Builder(range, (BaseAxisFormatter)new TimeAxisFormatter(1, 10, 1)).setGlobalRange(globalRange).build();
            final AxisComponent axis = new AxisComponent((AxisComponentModel)axisModel, AxisComponent.AxisOrientation.BOTTOM);
            axis.setShowAxisLine(false);
            axis.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
            axis.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    axis.setMarkerLengths(axis.getHeight(), 0);
                    axis.repaint();
                }
            });
            return axis;
        }
    }
}

