/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.capturedetails.DetailsCapturePane;
import com.android.tools.profilers.cpu.capturedetails.RecordingInitiatorPane;
import com.android.tools.profilers.cpu.capturedetails.StatusPane;
import com.google.common.annotations.VisibleForTesting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureView {
    @NotNull
    private final CpuProfilerStageView myStageView;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private CapturePane myCapturePane;
    @NotNull
    private final AspectObserver myObserver;

    public CpuCaptureView(@NotNull CpuProfilerStageView stageView) {
        this.myStageView = stageView;
        this.myStage = (CpuProfilerStage)stageView.getStage();
        this.myPanel = new JPanel(new BorderLayout());
        this.myObserver = new AspectObserver();
        this.myCapturePane = this.createCapturePane();
        this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_DETAILS, this::updateCaptureDetails).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, this::onCaptureStateChanged).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::updateCapturePane);
        this.myStage.getCaptureParser().getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_PARSING, this::updateCapturePane);
        this.updateCapturePane();
    }

    private void updateCaptureDetails() {
        this.myCapturePane.updateView();
    }

    private void onCaptureStateChanged() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STARTING || this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STOPPING) {
            return;
        }
        this.updateCapturePane();
    }

    private void updateCapturePane() {
        this.myPanel.removeAll();
        this.myCapturePane = this.createCapturePane();
        this.myPanel.add((Component)this.myCapturePane, "Center");
        this.myPanel.revalidate();
    }

    @NotNull
    private CapturePane createCapturePane() {
        if (this.myStage.getCaptureParser().isParsing()) {
            return new ParsingPane(this.myStageView);
        }
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            return new RecordingPane(this.myStageView);
        }
        if (this.myStage.getCapture() == null) {
            return new RecordingInitiatorPane(this.myStageView);
        }
        return new DetailsCapturePane(this.myStageView);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @VisibleForTesting
    static class ParsingPane
    extends StatusPane {
        static final String ABORT_BUTTON_TEXT = "Abort";

        public ParsingPane(@NotNull CpuProfilerStageView stageView) {
            super(stageView, "Parsing");
        }

        @Override
        @NotNull
        protected String getDurationText() {
            return TimeFormatter.getMultiUnitDurationString((long)TimeUnit.MILLISECONDS.toMicros(this.myStage.getCaptureParser().getParsingElapsedTimeMs()));
        }

        @Override
        protected JButton createAbortButton() {
            JButton abortButton = new JButton(ABORT_BUTTON_TEXT);
            abortButton.addActionListener(event -> {
                this.myStage.getCaptureParser().abortParsing();
                this.myStage.setCaptureState(CpuProfilerStage.CaptureState.IDLE);
                abortButton.setEnabled(false);
            });
            return abortButton;
        }
    }

    @VisibleForTesting
    static class RecordingPane
    extends StatusPane {
        private JButton myStopRecordingButton;

        public RecordingPane(@NotNull CpuProfilerStageView stageView) {
            super(stageView, "Recording");
            this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, () -> this.myStopRecordingButton.setEnabled(false));
        }

        @Override
        protected JButton createAbortButton() {
            this.myStopRecordingButton = new JButton("Stop");
            this.myStopRecordingButton.addActionListener(event -> this.myStage.toggleCapturing());
            this.myStopRecordingButton.setEnabled(!this.myStage.isApiInitiatedTracingInProgress());
            return this.myStopRecordingButton;
        }

        @Override
        @NotNull
        protected String getDurationText() {
            return TimeFormatter.getMultiUnitDurationString((long)this.myStage.getCaptureElapsedTimeUs());
        }
    }
}

