/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

abstract class CpuChartTooltipViewBase
extends MouseAdapter {
    @NotNull
    private final HTreeChart<CaptureNode> myChart;
    @NotNull
    private final TooltipComponent myTooltipComponent;
    @NotNull
    private final JPanel myContent;
    @NotNull
    protected final CpuProfilerStageView myStageView;

    protected CpuChartTooltipViewBase(@NotNull HTreeChart<CaptureNode> chart, @NotNull CpuProfilerStageView stageView) {
        this.myStageView = stageView;
        this.myChart = chart;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        this.myContent.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        this.myContent.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myTooltipComponent = new TooltipComponent.Builder((JComponent)this.myContent, chart, this.myStageView.getProfilersView().getComponent()).build();
        this.myTooltipComponent.registerListenersOn(chart);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.myTooltipComponent.setVisible(false);
        CaptureNode node = (CaptureNode)this.myChart.getNodeAt(e.getPoint());
        if (node != null) {
            this.myTooltipComponent.setVisible(true);
            this.showTooltip(node);
        }
    }

    protected JPanel getTooltipContainer() {
        return this.myContent;
    }

    protected abstract void showTooltip(@NotNull CaptureNode var1);
}

