/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeModel;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class CpuTraceTreeSorter
implements ColumnTreeBuilder.TreeSorter<DefaultMutableTreeNode> {
    @NotNull
    private JTree myTree;
    private DefaultMutableTreeNode myRoot;
    private CpuTreeModel myModel;
    private Comparator<DefaultMutableTreeNode> myComparator;

    public CpuTraceTreeSorter(@NotNull JTree tree) {
        this.myTree = tree;
    }

    public void setModel(CpuTreeModel model, Comparator<DefaultMutableTreeNode> sorting) {
        this.myModel = model;
        if (this.myModel != null) {
            this.myRoot = (DefaultMutableTreeNode)model.getRoot();
            this.sort(sorting, SortOrder.UNSORTED);
            this.myTree.invalidate();
        }
    }

    public void sort(Comparator<DefaultMutableTreeNode> comparator, SortOrder order) {
        this.myComparator = new MatchedNodeFirstComparator(comparator);
        this.sort();
    }

    private void sortTree(@NotNull DefaultMutableTreeNode parent) {
        if (parent.isLeaf()) {
            return;
        }
        int childCount = parent.getChildCount();
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children.add((DefaultMutableTreeNode)parent.getChildAt(i));
        }
        Collections.sort(children, this.myComparator);
        parent.removeAllChildren();
        for (DefaultMutableTreeNode node : children) {
            this.sortTree(node);
            parent.add(node);
        }
    }

    public void sort() {
        if (this.myModel != null && this.myRoot != null) {
            TreePath selectionPath = this.myTree.getSelectionPath();
            this.sortTree(this.myRoot);
            this.myTree.collapseRow(0);
            this.myTree.setSelectionPath(selectionPath);
            this.myTree.scrollPathToVisible(selectionPath);
            this.myModel.reload();
        }
    }

    private static class MatchedNodeFirstComparator
    implements Comparator<DefaultMutableTreeNode> {
        @NotNull
        private Comparator<DefaultMutableTreeNode> myComparator;

        MatchedNodeFirstComparator(@NotNull Comparator<DefaultMutableTreeNode> comparator) {
            this.myComparator = comparator;
        }

        @Override
        public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
            CpuTreeNode o1 = (CpuTreeNode)a.getUserObject();
            CpuTreeNode o2 = (CpuTreeNode)b.getUserObject();
            int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
            return cmp == 0 ? this.myComparator.compare(a, b) : cmp;
        }
    }
}

