/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterHandler;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.capturedetails.ChartDetailsView;
import com.android.tools.profilers.cpu.capturedetails.TreeDetailsView;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsCapturePane
extends CapturePane {
    @Nullable
    private CaptureDetailsView myDetailsView;
    @NotNull
    private final FilterComponent myFilterComponent;
    @NotNull
    private final ViewBinder<CpuProfilerStageView, CaptureDetails, CaptureDetailsView> myBinder = new ViewBinder();

    DetailsCapturePane(@NotNull CpuProfilerStageView view) {
        super(view);
        this.myBinder.bind(CaptureDetails.TopDown.class, TreeDetailsView.TopDownDetailsView::new);
        this.myBinder.bind(CaptureDetails.BottomUp.class, TreeDetailsView.BottomUpDetailsView::new);
        this.myBinder.bind(CaptureDetails.CallChart.class, ChartDetailsView.CallChartDetailsView::new);
        this.myBinder.bind(CaptureDetails.FlameChart.class, ChartDetailsView.FlameChartDetailsView::new);
        this.myTabsPanel.addChangeListener(event -> this.setCaptureDetailToTab());
        final CpuProfilerStage stage = (CpuProfilerStage)this.myStageView.getStage();
        this.myFilterComponent = new FilterComponent(stage.getCaptureFilter(), ProfilerLayout.FILTER_TEXT_FIELD_WIDTH, 5, 250).setMatchCountVisibility(false);
        this.myFilterComponent.getModel().setFilterHandler(new FilterHandler(){

            @NotNull
            protected FilterResult applyFilter(@NotNull Filter filter) {
                stage.setCaptureFilter(filter);
                return new FilterResult(stage.getCaptureFilterNodeCount(), !filter.isEmpty());
            }
        });
        this.myFilterComponent.setVisible(!this.myFilterComponent.getModel().getFilter().isEmpty());
        this.myFilterComponent.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
        FilterComponent.configureKeyBindingAndFocusBehaviors((JComponent)this, (FilterComponent)this.myFilterComponent, (JToggleButton)this.myToolbar.getFilterButton());
        this.updateView();
    }

    @Override
    void populateContent(@NotNull JPanel panel) {
        CaptureDetails details;
        boolean filterHasFocus = this.myFilterComponent.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (this.myFilterComponent.getParent() != null) {
            this.myFilterComponent.getParent().remove((Component)this.myFilterComponent);
        }
        if ((details = ((CpuProfilerStage)this.myStageView.getStage()).getCaptureDetails()) == null) {
            return;
        }
        this.myDetailsView = this.myBinder.build(this.myStageView, details);
        panel.add((Component)this.myFilterComponent, "North");
        panel.add((Component)this.myDetailsView.getComponent(), "Center");
        if (filterHasFocus) {
            this.myFilterComponent.requestFocusInWindow();
        }
    }

    private void setCaptureDetailToTab() {
        String tabTitle = this.myTabsPanel.getTitleAt(this.myTabsPanel.getSelectedIndex());
        CaptureDetails.Type type = this.myTabs.entrySet().stream().filter(e -> tabTitle.equals(e.getValue())).map(e -> (CaptureDetails.Type)((Object)((Object)e.getKey()))).findFirst().orElse(null);
        ((CpuProfilerStage)this.myStageView.getStage()).setCaptureDetails(type);
    }
}

