/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.capturedetails.BottomUpNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpTreeModel;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.CpuTraceTreeSorter;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeModel;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import com.android.tools.profilers.cpu.capturedetails.TopDownNode;
import com.android.tools.profilers.cpu.capturedetails.TopDownTreeModel;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TreeDetailsView<T extends CpuTreeNode<T>>
extends CaptureDetailsView {
    private static final Comparator<DefaultMutableTreeNode> DEFAULT_SORT_ORDER = Collections.reverseOrder(new DoubleValueNodeComparator(CpuTreeNode::getGlobalTotal));
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    private final AspectObserver myObserver = new AspectObserver();
    @Nullable
    protected final JTree myTree;
    @Nullable
    private final CpuTraceTreeSorter mySorter;

    private TreeDetailsView(@NotNull CpuProfilerStageView stageView, @Nullable CpuTreeModel<T> model) {
        if (model == null) {
            this.myPanel = TreeDetailsView.getNoDataForThread();
            this.myTree = null;
            this.mySorter = null;
            return;
        }
        this.myPanel = new JPanel(new CardLayout());
        this.myTree = new JTree();
        int defaultFontHeight = this.myTree.getFontMetrics(this.myTree.getFont()).getHeight();
        this.myTree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myTree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        this.myTree.setModel(model);
        this.mySorter = new CpuTraceTreeSorter(this.myTree);
        this.mySorter.setModel(model, DEFAULT_SORT_ORDER);
        this.myPanel.add((Component)this.createTableTree(), "Content");
        this.myPanel.add((Component)TreeDetailsView.getNoDataForRange(), "Empty content");
        CodeNavigator navigator = ((CpuProfilerStage)stageView.getStage()).getStudioProfilers().getIdeServices().getCodeNavigator();
        assert (((CpuProfilerStage)stageView.getStage()).getCapture() != null);
        if (((CpuProfilerStage)stageView.getStage()).getCapture().getType() != Cpu.CpuTraceType.ATRACE) {
            stageView.getIdeComponents().createContextMenuInstaller().installNavigationContextMenu(this.myTree, navigator, () -> TreeDetailsView.getCodeLocation(this.myTree));
        }
        TreeDetailsView.switchCardLayout(this.myPanel, model.isEmpty());
        model.getAspect().addDependency(this.myObserver).onChange((Enum)CpuTreeModel.Aspect.TREE_MODEL, () -> this.mySorter.sort());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    private JComponent createTableTree() {
        assert (this.myTree != null && this.mySorter != null);
        return new ColumnTreeBuilder(this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Name").setPreferredWidth(900).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MethodNameRenderer()).setComparator((Comparator)new NameValueNodeComparator())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRendererWithSparkline(CpuTreeNode::getGlobalTotal, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getGlobalTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getGlobalTotal, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getGlobalTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Self (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Children (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getGlobalChildrenTotal, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getGlobalChildrenTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getGlobalChildrenTotal, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getGlobalChildrenTotal))).setTreeSorter((ColumnTreeBuilder.TreeSorter)this.mySorter).setBorder(AdtUiUtils.DEFAULT_TOP_BORDER).setBackground(ProfilerColors.DEFAULT_BACKGROUND).setShowVerticalLines(true).setTableIntercellSpacing(new Dimension()).build();
    }

    @Nullable
    private static CodeLocation getCodeLocation(@NotNull JTree tree) {
        if (tree.getSelectionPath() == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
        return TreeDetailsView.modelToCodeLocation(((CpuTreeNode)node.getUserObject()).getMethodModel());
    }

    private static CpuTreeNode getNode(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        return (CpuTreeNode)node.getUserObject();
    }

    @Nullable
    private static CodeLocation modelToCodeLocation(CaptureNodeModel model) {
        if (model instanceof CppFunctionModel) {
            CppFunctionModel nativeFunction = (CppFunctionModel)model;
            return new CodeLocation.Builder(nativeFunction.getClassOrNamespace()).setMethodName(nativeFunction.getName()).setMethodParameters(nativeFunction.getParameters()).setNativeCode(true).setFileName(nativeFunction.getFileName()).setNativeVAddress(nativeFunction.getVAddress()).build();
        }
        if (model instanceof JavaMethodModel) {
            JavaMethodModel javaMethod = (JavaMethodModel)model;
            return new CodeLocation.Builder(javaMethod.getClassName()).setMethodName(javaMethod.getName()).setMethodSignature(javaMethod.getSignature()).setNativeCode(false).build();
        }
        return null;
    }

    static class BottomUpDetailsView
    extends TreeDetailsView<BottomUpNode> {
        BottomUpDetailsView(@NotNull CpuProfilerStageView view, @NotNull CaptureDetails.BottomUp bottomUp) {
            super(view, bottomUp.getModel());
            final BottomUpTreeModel model = bottomUp.getModel();
            if (model == null) {
                return;
            }
            assert (this.myTree != null);
            this.myTree.setRootVisible(false);
            this.myTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                    ((BottomUpTreeModel)myTree.getModel()).expand(node);
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) {
                }
            });
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                    if (type == TreeModelAdapter.EventType.NodesInserted && event.getTreePath().getPathCount() == 1) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                        Object[] inserted = event.getChildren();
                        if (inserted != null && inserted.length == root.getChildCount()) {
                            myTree.expandPath(new TreePath(root));
                        }
                    }
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }
            });
        }
    }

    static class TopDownDetailsView
    extends TreeDetailsView<TopDownNode> {
        TopDownDetailsView(@NotNull CpuProfilerStageView view, @NotNull CaptureDetails.TopDown topDown) {
            super(view, topDown.getModel());
            final TopDownTreeModel model = topDown.getModel();
            if (model == null) {
                return;
            }
            assert (this.myTree != null);
            TopDownDetailsView.expandTreeNodes(this.myTree);
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }
            });
        }

        private static void expandTreeNodes(JTree tree) {
            int maxRowsToExpand = 8;
            int i = 0;
            while (i < tree.getRowCount() && i < maxRowsToExpand) {
                tree.expandRow(i++);
            }
        }
    }

    private static class MethodNameRenderer
    extends CpuCaptureCellRenderer {
        private MethodNameRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() instanceof CpuTreeNode) {
                CpuTreeNode node = (CpuTreeNode)((DefaultMutableTreeNode)value).getUserObject();
                SimpleTextAttributes attributes = this.getTextAttributes(node);
                CaptureNodeModel model = node.getMethodModel();
                String classOrNamespace = "";
                if (model instanceof CppFunctionModel) {
                    classOrNamespace = ((CppFunctionModel)model).getClassOrNamespace();
                } else if (model instanceof JavaMethodModel) {
                    classOrNamespace = ((JavaMethodModel)model).getClassName();
                }
                if (model.getName().isEmpty()) {
                    this.setIcon(AllIcons.Debugger.ThreadSuspended);
                    this.append(classOrNamespace, attributes);
                } else {
                    this.setIcon(PlatformIcons.METHOD_ICON);
                    this.append(model.getName() + "()", attributes);
                    this.append(" (" + classOrNamespace + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else {
                this.append(value.toString());
            }
        }
    }

    private static class DoubleValueCellRendererWithSparkline
    extends DoubleValueCellRenderer {
        private Color mySparkLineColor = ProfilerColors.CPU_CAPTURE_SPARKLINE;
        private double myPercentage = Double.NEGATIVE_INFINITY;

        public DoubleValueCellRendererWithSparkline(Function<CpuTreeNode, Double> getter, boolean showPercentage, int alignment) {
            super(getter, showPercentage, alignment);
        }

        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            CpuTreeNode node = TreeDetailsView.getNode(value);
            if (node != null) {
                this.myPercentage = this.getGetter().apply(node) / TreeDetailsView.getNode(tree.getModel().getRoot()).getGlobalTotal();
            }
            this.mySparkLineColor = selected ? ProfilerColors.CPU_CAPTURE_SPARKLINE_SELECTED : ProfilerColors.CPU_CAPTURE_SPARKLINE;
        }

        protected void paintComponent(Graphics g) {
            if (this.myPercentage > 0.0) {
                g.setColor(this.mySparkLineColor);
                g.fillRect(ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_LEFT_PADDING, ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_TOP_BOTTOM_PADDING, (int)(this.myPercentage * (double)(this.getWidth() / 2 - ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_LEFT_PADDING)), this.getHeight() - ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_TOP_BOTTOM_PADDING * 2);
            }
            super.paintComponent(g);
        }
    }

    private static class DoubleValueCellRenderer
    extends CpuCaptureCellRenderer {
        private final Function<CpuTreeNode, Double> myGetter;
        private final boolean myShowPercentage;
        private final int myAlignment;

        public DoubleValueCellRenderer(Function<CpuTreeNode, Double> getter, boolean showPercentage, int alignment) {
            this.myGetter = getter;
            this.myShowPercentage = showPercentage;
            this.myAlignment = alignment;
            this.setTextAlign(alignment);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CpuTreeNode node = TreeDetailsView.getNode(value);
            if (node != null) {
                SimpleTextAttributes attributes = this.getTextAttributes(node);
                double v = this.myGetter.apply(node);
                if (this.myShowPercentage) {
                    CpuTreeNode root = TreeDetailsView.getNode(tree.getModel().getRoot());
                    this.append(String.format("%.2f", v / root.getGlobalTotal() * 100.0), attributes);
                } else {
                    this.append(String.format("%,.0f", v), attributes);
                }
            } else {
                this.append(value.toString());
            }
            if (this.myAlignment == 2) {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_CELL_INSETS);
            } else {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_CELL_INSETS);
            }
        }

        protected Function<CpuTreeNode, Double> getGetter() {
            return this.myGetter;
        }
    }

    private static abstract class CpuCaptureCellRenderer
    extends ColoredTreeCellRenderer {
        private static final Map<CaptureNode.FilterType, SimpleTextAttributes> TEXT_ATTRIBUTES = ImmutableMap.builder().put((Object)CaptureNode.FilterType.MATCH, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES).put((Object)CaptureNode.FilterType.EXACT_MATCH, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES).put((Object)CaptureNode.FilterType.UNMATCH, (Object)SimpleTextAttributes.GRAY_ATTRIBUTES).build();

        private CpuCaptureCellRenderer() {
        }

        @NotNull
        protected SimpleTextAttributes getTextAttributes(@NotNull CpuTreeNode node) {
            return TEXT_ATTRIBUTES.get((Object)node.getFilterType());
        }
    }

    private static class DoubleValueNodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private final Function<CpuTreeNode, Double> myGetter;

        DoubleValueNodeComparator(Function<CpuTreeNode, Double> getter) {
            this.myGetter = getter;
        }

        @Override
        public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
            CpuTreeNode o1 = (CpuTreeNode)a.getUserObject();
            CpuTreeNode o2 = (CpuTreeNode)b.getUserObject();
            return Double.compare(this.myGetter.apply(o1), this.myGetter.apply(o2));
        }
    }

    private static class NameValueNodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NameValueNodeComparator() {
        }

        @Override
        public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
            CpuTreeNode o1 = (CpuTreeNode)a.getUserObject();
            CpuTreeNode o2 = (CpuTreeNode)b.getUserObject();
            return o1.getMethodModel().getName().compareTo(o2.getMethodModel().getName());
        }
    }
}

