/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.nodemodel;

import com.android.tools.profilers.cpu.nodemodel.NativeNodeModel;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CppFunctionModel
extends NativeNodeModel {
    private static final Pattern PARAMETERS_SEPARATOR = Pattern.compile(", ");
    @NotNull
    private final String myClassOrNamespace;
    @NotNull
    private final List<String> myParameters;
    private final boolean myIsUserCode;
    private final String myFileName;
    private final long myVAddress;
    private String myFullName;
    private String myId;

    private CppFunctionModel(Builder builder) {
        this.myName = builder.myName;
        this.myClassOrNamespace = builder.myClassOrNamespace;
        this.myParameters = CppFunctionModel.buildParameters(builder.myParameters);
        this.myIsUserCode = builder.myIsUserCode;
        this.myFileName = builder.myFileName;
        this.myVAddress = builder.myVAddress;
    }

    @NotNull
    public String getClassOrNamespace() {
        return this.myClassOrNamespace;
    }

    @NotNull
    public List<String> getParameters() {
        return this.myParameters;
    }

    public boolean isUserCode() {
        return this.myIsUserCode;
    }

    public String getFileName() {
        return this.myFileName;
    }

    public long getVAddress() {
        return this.myVAddress;
    }

    @Override
    @NotNull
    public String getFullName() {
        if (this.myFullName == null) {
            String separator = StringUtil.isEmpty((String)this.myClassOrNamespace) ? "" : "::";
            this.myFullName = String.format("%s%s%s", this.myClassOrNamespace, separator, this.myName);
        }
        return this.myFullName;
    }

    @Override
    @NotNull
    public String getId() {
        if (this.myId == null) {
            this.myId = String.format("%s%s", this.getFullName(), this.myParameters.toString());
        }
        return this.myId;
    }

    private static List<String> buildParameters(@NotNull String parameters) {
        ArrayList<String> parsedParameters = new ArrayList<String>();
        if (parameters.isEmpty()) {
            return parsedParameters;
        }
        Collections.addAll(parsedParameters, PARAMETERS_SEPARATOR.split(parameters));
        return parsedParameters;
    }

    public static class Builder {
        @NotNull
        private final String myName;
        @NotNull
        private String myClassOrNamespace;
        private boolean myIsUserCode;
        @NotNull
        private String myParameters;
        private String myFileName;
        private long myVAddress;

        public Builder(@NotNull String name) {
            this.myName = name;
            this.myClassOrNamespace = "";
            this.myParameters = "";
        }

        public Builder setClassOrNamespace(@NotNull String classOrNamespace) {
            this.myClassOrNamespace = classOrNamespace;
            return this;
        }

        public Builder setParameters(@NotNull String parameters) {
            this.myParameters = parameters;
            return this;
        }

        public Builder setIsUserCode(boolean isUserCode) {
            this.myIsUserCode = isUserCode;
            return this;
        }

        public Builder setFileName(String fileName) {
            this.myFileName = fileName;
            return this;
        }

        public Builder setVAddress(long vAddress) {
            this.myVAddress = vAddress;
            return this;
        }

        public CppFunctionModel build() {
            return new CppFunctionModel(this);
        }
    }
}

