/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.SyscallModel;
import com.intellij.openapi.diagnostic.Logger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeNameParser {
    private static final Pattern JAVA_SEPARATOR_PATTERN = Pattern.compile("\\.");

    private static Logger getLogger() {
        return Logger.getInstance(NodeNameParser.class);
    }

    static CaptureNodeModel parseNodeName(@NotNull String fullName, boolean isUserWritten, @Nullable String fileName, long vAddress) {
        if (fullName.contains("(")) {
            return NodeNameParser.createCppFunctionModel(fullName, isUserWritten, fileName, vAddress);
        }
        if (fullName.contains(".")) {
            return NodeNameParser.createJavaMethodModel(fullName);
        }
        return new SyscallModel(fullName);
    }

    static CaptureNodeModel parseNodeName(@NotNull String fullName, boolean isUserWritten) {
        return NodeNameParser.parseNodeName(fullName, isUserWritten, null, -1L);
    }

    @NotNull
    public static CppFunctionModel createCppFunctionModel(String functionFullName, boolean isUserWritten, String fileName, long vAddress) {
        String returnType;
        int returnTypeSeparatorIndex;
        int paramsStartIndex;
        String parameters = "";
        int paramsEndIndex = functionFullName.lastIndexOf(41);
        if (paramsEndIndex != -1 && (paramsStartIndex = NodeNameParser.findMatchingOpeningParenthesisIndex(functionFullName, paramsEndIndex)) > 0) {
            parameters = functionFullName.substring(paramsStartIndex + 1, paramsEndIndex);
            functionFullName = functionFullName.substring(0, paramsStartIndex);
        }
        if ((returnTypeSeparatorIndex = NodeNameParser.separatorIndexOutsideOfTemplateInfo(functionFullName, " ", false)) >= 0 && !(returnType = functionFullName.substring(0, returnTypeSeparatorIndex)).equals("operator") && !returnType.endsWith("::operator")) {
            functionFullName = functionFullName.substring(returnTypeSeparatorIndex + 1);
        }
        String name = functionFullName;
        String classOrNamespace = "";
        int methodNameSeparatorIndex = NodeNameParser.separatorIndexOutsideOfTemplateInfo(functionFullName, "::", true);
        if (methodNameSeparatorIndex != -1) {
            classOrNamespace = functionFullName.substring(0, methodNameSeparatorIndex);
            name = functionFullName.substring(methodNameSeparatorIndex + 2);
        }
        return new CppFunctionModel.Builder(NodeNameParser.isOperatorOverload(name) ? name : NodeNameParser.removeTemplateInfo(name)).setClassOrNamespace(NodeNameParser.removeTemplateInfo(classOrNamespace)).setIsUserCode(isUserWritten).setParameters(NodeNameParser.removeTemplateInfo(parameters)).setFileName(fileName).setVAddress(vAddress).build();
    }

    @NotNull
    public static CppFunctionModel createCppFunctionModel(String functionFullName, boolean isUserWritten) {
        return NodeNameParser.createCppFunctionModel(functionFullName, isUserWritten, null, -1L);
    }

    private static int separatorIndexOutsideOfTemplateInfo(String functionFullName, String separator, boolean lastIndex) {
        int open = 0;
        int lastOccurrenceIndex = -1;
        for (int index = 0; index <= functionFullName.length() - separator.length(); ++index) {
            char ch = functionFullName.charAt(index);
            if (ch == '<') {
                ++open;
                continue;
            }
            if (ch == '>') {
                --open;
                continue;
            }
            if (open != 0 || !functionFullName.startsWith(separator, index)) continue;
            if (!lastIndex) {
                return index;
            }
            lastOccurrenceIndex = index;
        }
        return lastOccurrenceIndex;
    }

    private static boolean isOperatorOverload(@NotNull String functionName) {
        String operator = "operator";
        if (!functionName.startsWith("operator")) {
            return false;
        }
        if ("operator".length() == functionName.length()) {
            return true;
        }
        return !NodeNameParser.isCppIdentifierChar(functionName.charAt("operator".length()));
    }

    private static boolean isCppIdentifierChar(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || Character.isDigit(ch) || ch == '_';
    }

    @NotNull
    private static String removeTemplateInfo(@NotNull String fullSymbol) {
        StringBuilder filteredName = new StringBuilder();
        int open = 0;
        for (int i = 0; i < fullSymbol.length(); ++i) {
            char ch = fullSymbol.charAt(i);
            if (ch == '<') {
                ++open;
                continue;
            }
            if (ch == '>') {
                --open;
                continue;
            }
            if (open != 0) continue;
            filteredName.append(ch);
        }
        if (open != 0) {
            NodeNameParser.getLogger().warn(String.format("Native function signature (%s) without matching angle brackets.", fullSymbol));
            return fullSymbol;
        }
        return filteredName.toString();
    }

    private static int findMatchingOpeningParenthesisIndex(String functionName, int endIndex) {
        assert (functionName.charAt(endIndex) == ')');
        int count = 0;
        for (int i = endIndex; i >= 0; --i) {
            Character ch = Character.valueOf(functionName.charAt(i));
            if (ch.charValue() == ')') {
                ++count;
            } else if (ch.charValue() == '(') {
                --count;
            }
            if (count != 0) continue;
            return i;
        }
        NodeNameParser.getLogger().warn(String.format("Native function signature (%s) without matching parentheses.", functionName));
        return -1;
    }

    private static JavaMethodModel createJavaMethodModel(String fullName) {
        String[] splittedMethod = JAVA_SEPARATOR_PATTERN.split(fullName);
        int methodNameIndex = splittedMethod.length - 1;
        String methodName = splittedMethod[methodNameIndex];
        StringBuilder className = new StringBuilder(splittedMethod[0]);
        for (int i = 1; i < methodNameIndex; ++i) {
            className.append(".");
            className.append(splittedMethod[i]);
        }
        return new JavaMethodModel(methodName, className.toString());
    }
}

