/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventsCountDataSeries;
import com.android.tools.profilers.energy.EnergyEventsDataSeries;
import org.jetbrains.annotations.NotNull;

public class DetailedEnergyEventsCount {
    @NotNull
    private final RangedContinuousSeries myLocationCountSeries;
    @NotNull
    private final RangedContinuousSeries myWakeLockCountSeries;
    @NotNull
    private final RangedContinuousSeries myAlarmAndJobCountSeries;

    public DetailedEnergyEventsCount(@NotNull StudioProfilers profilers) {
        Range countRange = new Range(0.0, 400.0);
        EnergyEventsDataSeries sourceSeries = new EnergyEventsDataSeries(profilers.getClient(), profilers.getSession());
        Range dataRange = profilers.getTimeline().getDataRange();
        RangedSeries series = new RangedSeries(dataRange, (DataSeries)sourceSeries);
        this.myLocationCountSeries = new RangedContinuousSeries("Location", profilers.getTimeline().getViewRange(), countRange, (DataSeries)new EnergyEventsCountDataSeries((RangedSeries<EnergyProfiler.EnergyEvent>)series, EnergyDuration.Kind.LOCATION));
        this.myWakeLockCountSeries = new RangedContinuousSeries("Wake Locks", profilers.getTimeline().getViewRange(), countRange, (DataSeries)new EnergyEventsCountDataSeries((RangedSeries<EnergyProfiler.EnergyEvent>)series, EnergyDuration.Kind.WAKE_LOCK));
        this.myAlarmAndJobCountSeries = new RangedContinuousSeries("Alarms & Jobs", profilers.getTimeline().getViewRange(), countRange, (DataSeries)new EnergyEventsCountDataSeries((RangedSeries<EnergyProfiler.EnergyEvent>)series, EnergyDuration.Kind.ALARM, EnergyDuration.Kind.JOB));
    }

    @NotNull
    public RangedContinuousSeries getLocationCountSeries() {
        return this.myLocationCountSeries;
    }

    @NotNull
    public RangedContinuousSeries getWakeLockCountSeries() {
        return this.myWakeLockCountSeries;
    }

    @NotNull
    public RangedContinuousSeries getAlarmAndJobCountSeries() {
        return this.myAlarmAndJobCountSeries;
    }
}

