/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyUsageDataSeries;
import org.jetbrains.annotations.NotNull;

public class DetailedEnergyUsage
extends LineChartModel {
    @NotNull
    private final RangedContinuousSeries myCpuUsageSeries;
    @NotNull
    private final RangedContinuousSeries myNetworkUsageSeries;
    @NotNull
    private final RangedContinuousSeries myLocationUsageSeries;
    @NotNull
    private final Range myUsageRange = new Range(0.0, 400.0);

    public DetailedEnergyUsage(@NotNull StudioProfilers profilers) {
        EnergyUsageDataSeries locationDataSeries = new EnergyUsageDataSeries(profilers.getClient(), profilers.getSession(), EnergyProfiler.EnergySample::getLocationUsage);
        this.myLocationUsageSeries = new RangedContinuousSeries("Location", profilers.getTimeline().getViewRange(), this.myUsageRange, (DataSeries)locationDataSeries);
        this.add(this.myLocationUsageSeries);
        EnergyUsageDataSeries networkDataSeries = new EnergyUsageDataSeries(profilers.getClient(), profilers.getSession(), EnergyProfiler.EnergySample::getNetworkUsage);
        this.myNetworkUsageSeries = new RangedContinuousSeries("Network", profilers.getTimeline().getViewRange(), this.myUsageRange, (DataSeries)networkDataSeries);
        this.add(this.myNetworkUsageSeries);
        EnergyUsageDataSeries cpuDataSeries = new EnergyUsageDataSeries(profilers.getClient(), profilers.getSession(), EnergyProfiler.EnergySample::getCpuUsage);
        this.myCpuUsageSeries = new RangedContinuousSeries("CPU", profilers.getTimeline().getViewRange(), this.myUsageRange, (DataSeries)cpuDataSeries);
        this.add(this.myCpuUsageSeries);
    }

    @NotNull
    public Range getUsageRange() {
        return this.myUsageRange;
    }

    @NotNull
    public RangedContinuousSeries getCpuUsageSeries() {
        return this.myCpuUsageSeries;
    }

    @NotNull
    public RangedContinuousSeries getNetworkUsageSeries() {
        return this.myNetworkUsageSeries;
    }

    @NotNull
    public RangedContinuousSeries getLocationUsageSeries() {
        return this.myLocationUsageSeries;
    }
}

