/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.profilers.CloseButton;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.energy.EnergyCallstackView;
import com.android.tools.profilers.energy.EnergyDetailsOverview;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyDetailsView
extends JPanel {
    @NotNull
    private final EnergyCallstackView myCallstackView;
    @NotNull
    private final EnergyDetailsOverview myDetailsOverview;
    @NotNull
    private final JLabel myTitleLabel;

    public EnergyDetailsView(@NotNull EnergyProfilerStageView stageView) {
        super((LayoutManager)new TabularLayout("*", "Fit-,*"));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
        this.myTitleLabel = new JLabel();
        this.myTitleLabel.setFont(ProfilerFonts.STANDARD_FONT);
        this.myTitleLabel.setBorder((Border)new JBEmptyBorder(6, 10, 6, 3));
        titlePanel.add((Component)this.myTitleLabel, "West");
        CloseButton closeButton = new CloseButton(e -> ((EnergyProfilerStage)stageView.getStage()).setSelectedDuration(null));
        titlePanel.add((Component)((Object)closeButton), "East");
        this.myDetailsOverview = new EnergyDetailsOverview();
        this.myCallstackView = new EnergyCallstackView(stageView);
        JPanel detailsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        detailsPanel.setBorder((Border)new JBEmptyBorder(7, 10, 0, 10));
        detailsPanel.add(this.myDetailsOverview);
        detailsPanel.add(AdtUiUtils.createHorizontalSeparator());
        detailsPanel.add(this.myCallstackView);
        detailsPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myDetailsOverview.setBackground(null);
        this.myCallstackView.setBackground(null);
        JBScrollPane detailsScrollPane = new JBScrollPane((Component)detailsPanel);
        detailsScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)titlePanel, new TabularLayout.Constraint(0, 0));
        this.add((Component)detailsScrollPane, new TabularLayout.Constraint(1, 0));
    }

    public void setDuration(@Nullable EnergyDuration duration) {
        this.setBackground(JBColor.background());
        this.setVisible(duration != null && !duration.getEventList().isEmpty());
        this.myDetailsOverview.setDuration(duration);
        this.myCallstackView.setDuration(duration);
        this.myTitleLabel.setText(duration != null ? duration.getKind().getDisplayName() + " Details" : "");
        this.revalidate();
        this.repaint();
    }
}

