/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.profiler.proto.EnergyProfiler;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class EnergyDuration
implements Comparable<EnergyDuration> {
    @NotNull
    private final ImmutableList<EnergyProfiler.EnergyEvent> myEventList;

    public EnergyDuration(@NotNull List<EnergyProfiler.EnergyEvent> eventList) {
        assert (!eventList.isEmpty());
        this.myEventList = ImmutableList.copyOf(eventList);
    }

    @Override
    public int compareTo(@NotNull EnergyDuration another) {
        return (int)(this.getInitialTimestamp() - another.getInitialTimestamp());
    }

    public long getInitialTimestamp() {
        return ((EnergyProfiler.EnergyEvent)this.myEventList.get(0)).getTimestamp();
    }

    @NotNull
    public String getName() {
        Kind kind = this.getKind();
        String namePart = "";
        switch (kind) {
            case WAKE_LOCK: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasWakeLockAcquired()) break;
                namePart = EnergyDuration.getWakeLockLevelName(((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getWakeLockAcquired().getLevel());
                break;
            }
            case ALARM: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasAlarmSet()) break;
                namePart = EnergyDuration.getAlarmTypeName(((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getAlarmSet().getType());
                break;
            }
            case LOCATION: {
                namePart = "Request";
                break;
            }
        }
        return !namePart.isEmpty() ? String.format("%s: %s", kind.getDisplayName(), namePart) : kind.getDisplayName();
    }

    @NotNull
    public String getDescription() {
        switch (this.getKind()) {
            case WAKE_LOCK: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasWakeLockAcquired()) break;
                return ((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getWakeLockAcquired().getTag();
            }
            case ALARM: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasAlarmSet()) break;
                EnergyProfiler.AlarmSet alarmSet = ((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getAlarmSet();
                return alarmSet.hasOperation() ? alarmSet.getOperation().getCreatorPackage() : (alarmSet.hasListener() ? alarmSet.getListener().getTag() : "");
            }
            case JOB: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasJobScheduled()) break;
                EnergyProfiler.JobInfo job = ((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getJobScheduled().getJob();
                return String.format("%d:%s", job.getJobId(), job.getServiceName());
            }
        }
        return "N/A";
    }

    @NotNull
    public Kind getKind() {
        return Kind.from((EnergyProfiler.EnergyEvent)this.myEventList.get(0));
    }

    @NotNull
    public ImmutableList<EnergyProfiler.EnergyEvent> getEventList() {
        return this.myEventList;
    }

    @NotNull
    public static List<EnergyDuration> groupById(@NotNull List<EnergyProfiler.EnergyEvent> events) {
        LinkedHashMap durationMap = new LinkedHashMap();
        for (EnergyProfiler.EnergyEvent event : events) {
            if (durationMap.containsKey(event.getEventId())) {
                ((List)durationMap.get(event.getEventId())).add(event);
                continue;
            }
            ArrayList<EnergyProfiler.EnergyEvent> list2 = new ArrayList<EnergyProfiler.EnergyEvent>();
            list2.add(event);
            durationMap.put(event.getEventId(), list2);
        }
        return durationMap.values().stream().map(list -> new EnergyDuration((List<EnergyProfiler.EnergyEvent>)list)).collect(Collectors.toList());
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(EnergyDuration.class);
    }

    @NotNull
    public static String getWakeLockLevelName(@NotNull EnergyProfiler.WakeLockAcquired.Level level) {
        switch (level) {
            case FULL_WAKE_LOCK: {
                return "Full";
            }
            case PARTIAL_WAKE_LOCK: {
                return "Partial";
            }
            case SCREEN_DIM_WAKE_LOCK: {
                return "Screen Dim";
            }
            case SCREEN_BRIGHT_WAKE_LOCK: {
                return "Screen Bright";
            }
            case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                return "Proximity Screen Off";
            }
        }
        return "N/A";
    }

    @NotNull
    public static String getAlarmTypeName(@NotNull EnergyProfiler.AlarmSet.Type type) {
        switch (type) {
            case RTC: {
                return "RTC";
            }
            case RTC_WAKEUP: {
                return "RTC Wakeup";
            }
            case ELAPSED_REALTIME: {
                return "Elapsed Realtime";
            }
            case ELAPSED_REALTIME_WAKEUP: {
                return "Elapsed Realtime Wakeup";
            }
        }
        return "N/A";
    }

    @NotNull
    public static String getMetadataName(EnergyProfiler.EnergyEvent.MetadataCase metadataCase) {
        switch (metadataCase) {
            case WAKE_LOCK_ACQUIRED: {
                return "Acquired";
            }
            case WAKE_LOCK_RELEASED: {
                return "Released";
            }
            case ALARM_SET: {
                return "Set";
            }
            case ALARM_FIRED: {
                return "Triggered";
            }
            case ALARM_CANCELLED: {
                return "Cancelled";
            }
            case JOB_SCHEDULED: {
                return "Scheduled";
            }
            case JOB_STARTED: {
                return "Started";
            }
            case JOB_STOPPED: {
                return "Stopped";
            }
            case JOB_FINISHED: {
                return "Finished";
            }
            case LOCATION_UPDATE_REQUESTED: {
                return "Requested";
            }
            case LOCATION_CHANGED: {
                return "Location Updated";
            }
            case LOCATION_UPDATE_REMOVED: {
                return "Request Removed";
            }
        }
        return "";
    }

    @NotNull
    public String getCalledByTraceId() {
        return this.getEventList().stream().filter(e -> !e.getTraceId().isEmpty()).map(e -> e.getTraceId()).findFirst().orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnergyDuration duration = (EnergyDuration)o;
        return this.myEventList.equals(duration.myEventList);
    }

    public int hashCode() {
        return Objects.hash(this.myEventList);
    }

    public static enum Kind {
        UNKNOWN("N/A"),
        WAKE_LOCK("Wake Lock"),
        ALARM("Alarm"),
        JOB("Job"),
        LOCATION("Location");

        @NotNull
        private final String myDisplayName;

        @NotNull
        public static Kind from(@NotNull EnergyProfiler.EnergyEvent event) {
            switch (event.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: 
                case WAKE_LOCK_RELEASED: {
                    return WAKE_LOCK;
                }
                case ALARM_SET: 
                case ALARM_FIRED: 
                case ALARM_CANCELLED: {
                    return ALARM;
                }
                case JOB_SCHEDULED: 
                case JOB_STARTED: 
                case JOB_STOPPED: 
                case JOB_FINISHED: {
                    return JOB;
                }
                case LOCATION_UPDATE_REQUESTED: 
                case LOCATION_UPDATE_REMOVED: 
                case LOCATION_CHANGED: {
                    return LOCATION;
                }
            }
            EnergyDuration.getLogger().warn("Unsupported Kind for " + event.getMetadataCase().name());
            return UNKNOWN;
        }

        private Kind(String displayName) {
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }
    }
}

