/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.ProfilerColors;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnergyEventComponent
extends AnimatedComponent {
    protected static final int HIGHLIGHT_WIDTH = 2;
    @NotNull
    private final List<EventAction<EnergyProfiler.EnergyEvent>> myActionToDrawList;
    @NotNull
    private final EventModel<EnergyProfiler.EnergyEvent> myModel;
    @NotNull
    private final Color myHighlightColor;
    @NotNull
    private final Color myDurationColor;
    private boolean myRender;

    EnergyEventComponent(@NotNull EventModel<EnergyProfiler.EnergyEvent> model, @NotNull Color highlightColor) {
        this.myModel = model;
        this.myHighlightColor = highlightColor;
        this.myDurationColor = AdtUiUtils.overlayColor((int)ProfilerColors.DEFAULT_BACKGROUND.getRGB(), (int)this.myHighlightColor.getRGB(), (float)0.25f);
        this.myActionToDrawList = new ArrayList<EventAction<EnergyProfiler.EnergyEvent>>();
        this.myRender = true;
        this.myModel.addDependency(this.myAspectObserver).onChange((Enum)EventModel.Aspect.EVENT, this::modelChanged);
    }

    private void modelChanged() {
        this.myRender = true;
        this.opaqueRepaint();
    }

    private void renderToAction() {
        this.myActionToDrawList.clear();
        double minUs = this.myModel.getRangedSeries().getXRange().getMin();
        double maxUs = this.myModel.getRangedSeries().getXRange().getMax();
        for (SeriesData data : this.myModel.getRangedSeries().getSeries()) {
            if (!((double)((EventAction)data.value).getStartUs() <= maxUs) || !((double)((EventAction)data.value).getEndUs() >= minUs)) continue;
            this.myActionToDrawList.add((EventAction<EnergyProfiler.EnergyEvent>)data.value);
        }
    }

    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myRender) {
            this.renderToAction();
            this.myRender = false;
        }
        Color currentColor = g.getColor();
        Stroke currentStroke = g.getStroke();
        double minUs = this.myModel.getRangedSeries().getXRange().getMin();
        double maxUs = this.myModel.getRangedSeries().getXRange().getMax();
        double scaleFactor = dim.getWidth();
        double height = dim.getHeight() - 2.0;
        for (EventAction<EnergyProfiler.EnergyEvent> action : this.myActionToDrawList) {
            double normalizedPositionStart = (Math.max(minUs, (double)action.getStartUs()) - minUs) / (maxUs - minUs);
            AffineTransform transform = AffineTransform.getTranslateInstance(normalizedPositionStart * scaleFactor, 0.0);
            double xPosition = transform.getTranslateX() - 1.0;
            double yPosition = transform.getTranslateY() + 1.0;
            if ((double)action.getStartUs() >= minUs) {
                g.setColor(this.myHighlightColor);
                g.fill(new Rectangle2D.Double(xPosition, yPosition, 2.0, height));
                xPosition += 2.0;
            }
            if (((EnergyProfiler.EnergyEvent)action.getType()).getIsTerminal()) continue;
            double normalizedPositionEnd = (Math.min(maxUs, (double)action.getEndUs()) - minUs) / (maxUs - minUs);
            double length = (normalizedPositionEnd - normalizedPositionStart) * scaleFactor;
            g.setColor(this.myDurationColor);
            g.fill(new Rectangle2D.Double(xPosition, yPosition, length, height));
        }
        g.setColor(currentColor);
        g.setStroke(currentStroke);
    }

    @VisibleForTesting
    @NotNull
    List<EventAction<EnergyProfiler.EnergyEvent>> getActionToDrawList() {
        return this.myActionToDrawList;
    }
}

