/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EnergyEventsCountDataSeries
implements DataSeries<Long> {
    @NotNull
    private final RangedSeries<EnergyProfiler.EnergyEvent> myDelegateSeries;
    private final List<EnergyDuration.Kind> myKindsFilter;

    public EnergyEventsCountDataSeries(@NotNull RangedSeries<EnergyProfiler.EnergyEvent> delegateSeries, EnergyDuration.Kind ... kindsFilter) {
        this.myDelegateSeries = delegateSeries;
        this.myKindsFilter = Arrays.asList(kindsFilter);
    }

    public List<SeriesData<Long>> getDataForXRange(Range xRange) {
        List sourceData = this.myDelegateSeries.getSeries();
        long position = (long)xRange.getMax();
        HashSet<Integer> activeEventGroups = new HashSet<Integer>();
        for (SeriesData eventData : sourceData) {
            if (!this.myKindsFilter.contains((Object)EnergyDuration.Kind.from((EnergyProfiler.EnergyEvent)eventData.value))) continue;
            if (eventData.x > position) break;
            if (!((EnergyProfiler.EnergyEvent)eventData.value).getIsTerminal()) {
                activeEventGroups.add(((EnergyProfiler.EnergyEvent)eventData.value).getEventId());
                continue;
            }
            activeEventGroups.remove(((EnergyProfiler.EnergyEvent)eventData.value).getEventId());
        }
        return Arrays.asList(new SeriesData(position, (Object)activeEventGroups.size()));
    }

    public List<EnergyDuration.Kind> getKindsFilter() {
        return this.myKindsFilter;
    }
}

