/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyEventsFetcher {
    private final AspectObserver myAspectObserver = new AspectObserver();
    @NotNull
    private final EnergyServiceGrpc.EnergyServiceBlockingStub myClient;
    @NotNull
    Common.Session mySession;
    @NotNull
    private final List<Listener> myListeners = new ArrayList<Listener>();
    @NotNull
    private final Range myRange;
    @Nullable
    private List<EnergyDuration> myDurationList;

    public EnergyEventsFetcher(@NotNull EnergyServiceGrpc.EnergyServiceBlockingStub client, @NotNull Common.Session session, @NotNull Range range) {
        this.myClient = client;
        this.mySession = session;
        this.myRange = range;
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::handleRangeUpdated);
        this.handleRangeUpdated();
    }

    public void addListener(@NotNull Listener listener) {
        this.myListeners.add(listener);
        if (this.myDurationList != null) {
            this.fireListeners(this.myDurationList);
        }
    }

    private void handleRangeUpdated() {
        ArrayList<EnergyDuration> durationList = new ArrayList<EnergyDuration>();
        if (!this.myRange.isEmpty()) {
            EnergyProfiler.EnergyRequest request = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMax())).build();
            List eventList = this.myClient.getEvents(request).getEventsList();
            List<EnergyDuration> partialDurations = EnergyDuration.groupById(eventList);
            for (EnergyDuration partialDuration : partialDurations) {
                EnergyProfiler.EnergyEventGroupRequest eventGroupRequest = EnergyProfiler.EnergyEventGroupRequest.newBuilder().setSession(this.mySession).setEventId(((EnergyProfiler.EnergyEvent)partialDuration.getEventList().get(0)).getEventId()).build();
                durationList.add(new EnergyDuration(this.myClient.getEventGroup(eventGroupRequest).getEventsList()));
            }
        }
        if (this.myDurationList == null || !this.myDurationList.equals(durationList)) {
            this.myDurationList = durationList;
            this.fireListeners(this.myDurationList);
        }
    }

    private void fireListeners(@NotNull List<EnergyDuration> list) {
        for (Listener l : this.myListeners) {
            l.onUpdated(list);
        }
    }

    public static interface Listener {
        public void onUpdated(@NotNull List<EnergyDuration> var1);
    }
}

