/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.instructions.InstructionsRenderer;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyEventsTableTooltipInfoModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyEventsTableTooltipInfoComponent
extends AnimatedComponent {
    private final FontMetrics BOLD_FONT_METRICS;
    private final FontMetrics ITALIC_FONT_METRICS;
    private final int VERTICAL_MARGIN_PX;
    private final int VERTICAL_PADDING_PX;
    private final int BOTTOM_RIGHT_EXTRA_MARGIN_PX;
    private final int HORIZONTAL_PADDING_PX;
    private final int MIN_TOOLTIP_WIDTH;
    private final EnergyEventsTableTooltipInfoModel myModel;
    @NotNull
    private final List<RenderInstruction> myInstructions;

    public EnergyEventsTableTooltipInfoComponent(@NotNull EnergyEventsTableTooltipInfoModel model) {
        this.BOLD_FONT_METRICS = UIUtilities.getFontMetrics((JComponent)((Object)this), (Font)this.mDefaultFontMetrics.getFont().deriveFont(1));
        this.ITALIC_FONT_METRICS = UIUtilities.getFontMetrics((JComponent)((Object)this), (Font)this.mDefaultFontMetrics.getFont().deriveFont(2));
        this.VERTICAL_PADDING_PX = this.VERTICAL_MARGIN_PX = JBUI.scale((int)8);
        this.BOTTOM_RIGHT_EXTRA_MARGIN_PX = JBUI.scale((int)4);
        this.HORIZONTAL_PADDING_PX = JBUI.scale((int)10);
        this.MIN_TOOLTIP_WIDTH = JBUI.scale((int)112);
        this.myInstructions = new ArrayList<RenderInstruction>();
        this.myModel = model;
        this.myModel.addDependency(this.myAspectObserver).onChange((Enum)EnergyEventsTableTooltipInfoModel.Aspect.EVENT, this::eventChanged);
    }

    private void eventChanged() {
        this.myInstructions.clear();
        if (this.myModel.getDuration() == null) {
            return;
        }
        switch (this.myModel.getDuration().getKind()) {
            case WAKE_LOCK: 
            case JOB: {
                this.renderJobAndWakeLockEvent();
                break;
            }
            case ALARM: {
                this.renderAlarmEvent();
                break;
            }
            case LOCATION: {
                this.renderLocationEvent();
                break;
            }
        }
        if (this.myInstructions.isEmpty()) {
            this.myInstructions.add((RenderInstruction)new TextInstruction(this.mDefaultFontMetrics, "No data."));
        }
        if (this.myInstructions.get(this.myInstructions.size() - 1) instanceof NewRowInstruction) {
            this.myInstructions.remove(this.myInstructions.size() - 1);
        }
    }

    private void renderText(@Nullable String string) {
        if (string != null) {
            this.myInstructions.add((RenderInstruction)new TextInstruction(this.mDefaultFontMetrics, string));
            this.myInstructions.add((RenderInstruction)new NewRowInstruction(this.VERTICAL_MARGIN_PX));
        }
    }

    private void renderNameValuePair(@NotNull String name, @Nullable String value) {
        if (value == null) {
            return;
        }
        this.myInstructions.add((RenderInstruction)new TextInstruction(this.BOLD_FONT_METRICS, name));
        this.myInstructions.add((RenderInstruction)new TextInstruction(this.mDefaultFontMetrics, ": " + value));
        this.myInstructions.add((RenderInstruction)new NewRowInstruction(this.VERTICAL_MARGIN_PX));
    }

    private void renderJobAndWakeLockEvent() {
        this.renderText(this.myModel.getStatusString());
        this.renderText(this.myModel.getRangeString());
        this.renderNameValuePair("Duration", this.myModel.getDurationString());
    }

    private void renderAlarmEvent() {
        if (this.myModel.getDuration() == null) {
            return;
        }
        this.renderText(this.myModel.getStatusString());
        EnergyProfiler.EnergyEvent firstEvent = (EnergyProfiler.EnergyEvent)this.myModel.getDuration().getEventList().get(0);
        if (firstEvent.hasAlarmSet()) {
            if (firstEvent.getAlarmSet().hasOperation()) {
                this.myInstructions.add((RenderInstruction)new TextInstruction(this.BOLD_FONT_METRICS, "Intent"));
                String packageString = firstEvent.getAlarmSet().getOperation().getCreatorPackage();
                packageString = packageString.substring(packageString.lastIndexOf(46) + 1);
                int uid = firstEvent.getAlarmSet().getOperation().getCreatorUid();
                this.myInstructions.add((RenderInstruction)new TextInstruction(this.mDefaultFontMetrics, ": " + packageString));
                this.myInstructions.add((RenderInstruction)new TextInstruction(this.ITALIC_FONT_METRICS, " (" + uid + ")"));
                this.myInstructions.add((RenderInstruction)new NewRowInstruction(this.VERTICAL_MARGIN_PX));
            }
            long triggerTimeUs = TimeUnit.NANOSECONDS.toMicros(firstEvent.getTimestamp());
            long triggerTimeMs = TimeUnit.NANOSECONDS.toMillis(firstEvent.getTimestamp());
            this.myInstructions.add((RenderInstruction)new TextInstruction(this.BOLD_FONT_METRICS, "Created"));
            this.myInstructions.add((RenderInstruction)new TextInstruction(this.mDefaultFontMetrics, ": " + this.myModel.getDateFormattedString(triggerTimeMs)));
            this.myInstructions.add((RenderInstruction)new TextInstruction(this.ITALIC_FONT_METRICS, " (" + this.myModel.getSimplifiedClockFormattedString(triggerTimeUs) + ")"));
            this.myInstructions.add((RenderInstruction)new NewRowInstruction(this.VERTICAL_MARGIN_PX));
            long frequency = TimeUnit.MILLISECONDS.toMicros(firstEvent.getAlarmSet().getIntervalMs());
            if (this.myModel.getCurrentSelectedEvent() == null) {
                if (frequency != 0L) {
                    String frequencyString = TimeFormatter.getSingleUnitDurationString((long)frequency);
                    this.renderNameValuePair("Repeats", "Every " + frequencyString);
                }
            } else {
                long scheduledTimeUs = -1L;
                ImmutableList<EnergyProfiler.EnergyEvent> events = this.myModel.getDuration().getEventList();
                for (int k = 0; k < events.size(); ++k) {
                    if (events.get(k) != this.myModel.getCurrentSelectedEvent()) continue;
                    if (((EnergyProfiler.EnergyEvent)events.get(k)).hasAlarmFired()) {
                        scheduledTimeUs = TimeUnit.NANOSECONDS.toMicros(((EnergyProfiler.EnergyEvent)events.get(k)).getTimestamp()) + frequency;
                    }
                    if (k + 1 >= events.size()) continue;
                    if (((EnergyProfiler.EnergyEvent)events.get(k + 1)).hasAlarmCancelled()) {
                        scheduledTimeUs = -1L;
                    }
                    if (!((EnergyProfiler.EnergyEvent)events.get(k + 1)).hasAlarmFired()) continue;
                    scheduledTimeUs = TimeUnit.NANOSECONDS.toMicros(((EnergyProfiler.EnergyEvent)events.get(k + 1)).getTimestamp());
                }
                if (scheduledTimeUs != -1L) {
                    this.myInstructions.add((RenderInstruction)new TextInstruction(this.BOLD_FONT_METRICS, "Next scheduled"));
                    this.myInstructions.add((RenderInstruction)new TextInstruction(this.mDefaultFontMetrics, ": " + this.myModel.getDateFormattedString(TimeUnit.MICROSECONDS.toMillis(scheduledTimeUs))));
                    this.myInstructions.add((RenderInstruction)new TextInstruction(this.ITALIC_FONT_METRICS, " (" + this.myModel.getSimplifiedClockFormattedString(scheduledTimeUs) + ")"));
                    this.myInstructions.add((RenderInstruction)new NewRowInstruction(this.VERTICAL_MARGIN_PX));
                }
            }
        }
    }

    private void renderLocationEvent() {
        if (this.myModel.getDuration() == null) {
            return;
        }
        this.renderText(this.myModel.getStatusString());
        EnergyProfiler.EnergyEvent firstEvent = (EnergyProfiler.EnergyEvent)this.myModel.getDuration().getEventList().get(0);
        if (firstEvent.hasLocationUpdateRequested() && firstEvent.getLocationUpdateRequested().hasRequest()) {
            this.renderNameValuePair("Priority", firstEvent.getLocationUpdateRequested().getRequest().getPriority().toString());
            long frequency = TimeUnit.MILLISECONDS.toMicros(firstEvent.getLocationUpdateRequested().getRequest().getIntervalMs());
            if (this.myModel.getCurrentSelectedEvent() == null && frequency != 0L) {
                String frequencyString = TimeFormatter.getSingleUnitDurationString((long)frequency);
                this.renderNameValuePair("Frequency", "Every " + frequencyString);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    List<RenderInstruction> getInstructions() {
        return this.myInstructions;
    }

    public Dimension getPreferredSize() {
        InstructionsRenderer state = new InstructionsRenderer(this.myInstructions, InstructionsRenderer.HorizontalAlignment.LEFT);
        Dimension renderSize = state.getRenderSize();
        return new Dimension(Math.max(this.MIN_TOOLTIP_WIDTH, renderSize.width + 2 * this.HORIZONTAL_PADDING_PX + this.BOTTOM_RIGHT_EXTRA_MARGIN_PX), renderSize.height + 2 * this.VERTICAL_MARGIN_PX + this.BOTTOM_RIGHT_EXTRA_MARGIN_PX);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void draw(Graphics2D g2d, Dimension dim) {
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
        g2d.setColor(this.getForeground());
        g2d.translate(this.HORIZONTAL_PADDING_PX, this.VERTICAL_PADDING_PX);
        InstructionsRenderer state = new InstructionsRenderer(this.myInstructions, InstructionsRenderer.HorizontalAlignment.LEFT);
        state.draw((JComponent)((Object)this), g2d);
        g2d.translate(-this.HORIZONTAL_PADDING_PX, -this.VERTICAL_PADDING_PX);
    }
}

