/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class EnergyMonitorView
extends ProfilerMonitorView<EnergyMonitor> {
    private static final String ENERGY_PROFILER_URL = "https://developer.android.com/studio/profile/energy-profiler";
    public static final double CHART_INTERVAL_US = TimeUnit.MILLISECONDS.toMicros(200L);

    public EnergyMonitorView(@NotNull StudioProfilersView profilersView, @NotNull EnergyMonitor monitor) {
        super(monitor);
    }

    @Override
    protected void populateDisabledView(JPanel container) {
        container.setLayout((LayoutManager)new TabularLayout("*,Fit-,*", "*,Fit-,Fit-,*"));
        JLabel disabledMessage = new JLabel("Energy profiler unavailable");
        disabledMessage.setFont(ProfilerFonts.H2_FONT);
        disabledMessage.setHorizontalAlignment(0);
        disabledMessage.setBorder((Border)new JBEmptyBorder(0, 0, 6, 0));
        container.add((Component)disabledMessage, new TabularLayout.Constraint(1, 0, 3));
        HyperlinkLabel detailedMessage = new HyperlinkLabel();
        detailedMessage.setFont(ProfilerFonts.STANDARD_FONT);
        detailedMessage.setHyperlinkTarget(ENERGY_PROFILER_URL);
        detailedMessage.setHyperlinkText("Supported only on devices running Android 8.0 (API level 26) and higher. ", "Learn More", "");
        container.add((Component)detailedMessage, new TabularLayout.Constraint(2, 1));
    }

    @Override
    protected void populateUi(JPanel container) {
        container.setLayout((LayoutManager)new TabularLayout("*", "*"));
        container.setFocusable(true);
        JLabel label = new JLabel(((EnergyMonitor)((Object)this.getMonitor())).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((EnergyMonitor)((Object)this.getMonitor())).getAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(false);
        leftAxis.setShowUnitAtMax(false);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        LineChart lineChart = new LineChart((LineChartModel)((EnergyMonitor)((Object)this.getMonitor())).getUsage());
        lineChart.setMaxLineColor(ProfilerColors.MONITOR_MAX_LINE);
        lineChart.setMaxLineMargin(40);
        lineChart.setFillEndGap(true);
        LineConfig config = new LineConfig(ProfilerColors.ENERGY_USAGE).setFilled(true).setLegendIconType(LegendConfig.IconType.NONE).setDataBucketInterval(CHART_INTERVAL_US);
        lineChart.configure(((EnergyMonitor)((Object)this.getMonitor())).getUsage().getUsageDataSeries(), config);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        ((EnergyMonitor)((Object)this.getMonitor())).addDependency(this).onChange((Enum)ProfilerMonitor.Aspect.FOCUS, () -> lineChart.setShowMaxLine(((EnergyMonitor)((Object)((Object)this.getMonitor()))).isFocused()));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        EnergyMonitor.Legends legends = ((EnergyMonitor)((Object)this.getMonitor())).getLegends();
        LegendComponent legendComponent = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.MONITOR_LEGEND_RIGHT_PADDING).build();
        legendComponent.configure((Legend)legends.getUsageLegend(), new LegendConfig(config));
        legendPanel.add((Component)legendComponent, "East");
        container.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        container.add((Component)leftAxis, new TabularLayout.Constraint(0, 0));
        container.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
    }
}

