/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.EnergyAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.energy.EnergyEventMetadata;
import com.android.tools.profilers.analytics.energy.EnergyRangeMetadata;
import com.android.tools.profilers.energy.DetailedEnergyEventsCount;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventOrigin;
import com.android.tools.profilers.energy.EnergyEventsDataSeries;
import com.android.tools.profilers.energy.EnergyEventsFetcher;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.android.tools.profilers.energy.EnergyProfilerAspect;
import com.android.tools.profilers.energy.EnergyTraceCache;
import com.android.tools.profilers.energy.MergedEnergyEventsDataSeries;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_ENERGY_SELECTION = "energy.used.selection";
    private static final String ENERGY_EVENT_ORIGIN_INDEX = "energy.event.origin";
    @NotNull
    private final DetailedEnergyUsage myDetailedUsage;
    @NotNull
    private final ResizingAxisComponentModel myAxis;
    @NotNull
    private final EventMonitor myEventMonitor;
    @NotNull
    private final EnergyUsageLegends myLegends;
    @NotNull
    private final EnergyUsageLegends myUsageTooltipLegends;
    @NotNull
    private final EnergyEventLegends myEventTooltipLegends;
    @NotNull
    private final SelectionModel mySelectionModel;
    @NotNull
    private final EnergyEventsFetcher myFetcher;
    @NotNull
    private final StateChartModel<EnergyProfiler.EnergyEvent> myEventModel;
    @NotNull
    private final EaseOutModel myInstructionsEaseOutModel;
    @NotNull
    private final Updatable myUpdatable;
    private AspectObserver myAspectObserver = new AspectObserver();
    private AspectModel<EnergyProfilerAspect> myAspect = new AspectModel();
    @NotNull
    private final EnergyTraceCache myTraceCache = new EnergyTraceCache(this);
    @Nullable
    private EnergyDuration mySelectedDuration;

    public EnergyProfilerStage(final @NotNull StudioProfilers profilers) {
        super(profilers);
        this.myDetailedUsage = new DetailedEnergyUsage(profilers);
        this.myAxis = (ResizingAxisComponentModel)new ResizingAxisComponentModel.Builder(this.myDetailedUsage.getUsageRange(), (BaseAxisFormatter)EnergyAxisFormatter.DEFAULT).setMarkerRange(EnergyMonitor.AXIS_MARKER_RANGE).build();
        this.myEventMonitor = new EventMonitor(profilers);
        this.myLegends = new EnergyUsageLegends(this.myDetailedUsage, profilers.getTimeline().getDataRange());
        this.myUsageTooltipLegends = new EnergyUsageLegends(this.myDetailedUsage, profilers.getTimeline().getTooltipRange());
        this.myEventTooltipLegends = new EnergyEventLegends(new DetailedEnergyEventsCount(profilers), profilers.getTimeline().getTooltipRange());
        final EnergyEventsDataSeries eventsDataSeries = new EnergyEventsDataSeries(profilers.getClient(), profilers.getSession());
        this.mySelectionModel = new SelectionModel(profilers.getTimeline().getSelectionRange());
        this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached());
        profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, () -> this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached()));
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                EnergyProfilerStage.this.setProfilerMode(ProfilerMode.EXPANDED);
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
                List<EnergyProfiler.EnergyEvent> energyEvents = eventsDataSeries.getDataForXRange(EnergyProfilerStage.this.mySelectionModel.getSelectionRange()).stream().map(seriesData -> (EnergyProfiler.EnergyEvent)seriesData.value).collect(Collectors.toList());
                if (!energyEvents.isEmpty()) {
                    List<EnergyDuration> energyDurations = EnergyDuration.groupById(energyEvents);
                    profilers.getIdeServices().getFeatureTracker().trackSelectEnergyRange(new EnergyRangeMetadata(energyDurations));
                }
                profilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(EnergyProfilerStage.HAS_USED_ENERGY_SELECTION, true);
                EnergyProfilerStage.this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }

            public void selectionCleared() {
                EnergyProfilerStage.this.setProfilerMode(ProfilerMode.NORMAL);
            }
        });
        this.myFetcher = new EnergyEventsFetcher(profilers.getClient().getEnergyClient(), profilers.getSession(), profilers.getTimeline().getSelectionRange());
        this.myEventModel = new StateChartModel();
        Range range = profilers.getTimeline().getViewRange();
        this.myEventModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(eventsDataSeries, EnergyDuration.Kind.ALARM, EnergyDuration.Kind.JOB)));
        this.myEventModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(eventsDataSeries, EnergyDuration.Kind.WAKE_LOCK)));
        this.myEventModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(eventsDataSeries, EnergyDuration.Kind.LOCATION)));
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myUpdatable = elapsedNs -> this.getStudioProfilers().getTimeline().getTooltipRange().changed((Enum)Range.Aspect.RANGE);
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().register(this.myUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
    }

    @NotNull
    public EnergyEventsFetcher getEnergyEventsFetcher() {
        return this.myFetcher;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public DetailedEnergyUsage getDetailedUsage() {
        return this.myDetailedUsage;
    }

    @NotNull
    StateChartModel<EnergyProfiler.EnergyEvent> getEventModel() {
        return this.myEventModel;
    }

    @NotNull
    public AxisComponentModel getAxis() {
        return this.myAxis;
    }

    @NotNull
    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public EnergyUsageLegends getLegends() {
        return this.myLegends;
    }

    @NotNull
    public EnergyUsageLegends getUsageTooltipLegends() {
        return this.myUsageTooltipLegends;
    }

    @NotNull
    public EnergyEventLegends getEventTooltipLegends() {
        return this.myEventTooltipLegends;
    }

    @NotNull
    public String getName() {
        return "ENERGY";
    }

    @NotNull
    public AspectModel<EnergyProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @Nullable
    public EnergyDuration getSelectedDuration() {
        return this.mySelectedDuration;
    }

    public void setSelectedDuration(@Nullable EnergyDuration duration) {
        if (Objects.equals(this.mySelectedDuration, duration) || !this.canSelectDuration(duration)) {
            return;
        }
        this.mySelectedDuration = duration;
        this.myAspect.changed((Enum)EnergyProfilerAspect.SELECTED_EVENT_DURATION);
        if (this.mySelectedDuration != null) {
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectEnergyEvent(new EnergyEventMetadata((Collection<EnergyProfiler.EnergyEvent>)this.mySelectedDuration.getEventList()));
        }
    }

    @NotNull
    public EnergyTraceCache getEventsTraceCache() {
        return this.myTraceCache;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    public boolean hasUserUsedEnergySelection() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_ENERGY_SELECTION, false);
    }

    @NotNull
    public ByteString requestBytes(@NotNull String id) {
        if (StringUtil.isEmpty((String)id)) {
            return ByteString.EMPTY;
        }
        Transport.BytesRequest request = Transport.BytesRequest.newBuilder().setStreamId(this.getStudioProfilers().getSession().getStreamId()).setId(id).build();
        Transport.BytesResponse response = this.getStudioProfilers().getClient().getTransportClient().getBytes(request);
        return response.getContents();
    }

    @NotNull
    public EnergyDuration updateDuration(@NotNull EnergyDuration duration) {
        if (((EnergyProfiler.EnergyEvent)duration.getEventList().get(duration.getEventList().size() - 1)).getIsTerminal()) {
            return duration;
        }
        EnergyProfiler.EnergyEventGroupRequest request = EnergyProfiler.EnergyEventGroupRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setEventId(((EnergyProfiler.EnergyEvent)duration.getEventList().get(0)).getEventId()).build();
        return new EnergyDuration(this.getStudioProfilers().getClient().getEnergyClient().getEventGroup(request).getEventsList());
    }

    @NotNull
    public EnergyEventOrigin getEventOrigin() {
        int savedOriginOrdinal = this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getInt(ENERGY_EVENT_ORIGIN_INDEX, EnergyEventOrigin.ALL.ordinal());
        return EnergyEventOrigin.values()[savedOriginOrdinal];
    }

    public void setEventOrigin(@NotNull EnergyEventOrigin origin) {
        if (this.getEventOrigin() != origin) {
            this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setInt(ENERGY_EVENT_ORIGIN_INDEX, origin.ordinal());
            if (!this.canSelectDuration(this.getSelectedDuration())) {
                this.setSelectedDuration(null);
            }
            this.myAspect.changed((Enum)EnergyProfilerAspect.SELECTED_ORIGIN_FILTER);
        }
    }

    private boolean canSelectDuration(@Nullable EnergyDuration duration) {
        return duration == null || !this.filterByOrigin((List<EnergyDuration>)ImmutableList.of((Object)duration)).isEmpty();
    }

    @NotNull
    public List<EnergyDuration> filterByOrigin(@NotNull List<EnergyDuration> list) {
        String appName = this.getStudioProfilers().getSelectedAppName();
        return list.stream().filter(duration -> this.getEventOrigin().isValid(appName, this.myTraceCache.getTraceData(duration.getCalledByTraceId()))).collect(Collectors.toList());
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public static class EnergyEventLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myLocationLegend;
        @NotNull
        private final SeriesLegend myWakeLockLegend;
        @NotNull
        private final SeriesLegend myAlarmAndJobLegend;
        @NotNull
        private final Range myRange;
        @NotNull
        private final SingleUnitAxisFormatter myFormatter = new SingleUnitAxisFormatter(1, 5, 5, "");

        EnergyEventLegends(@NotNull DetailedEnergyEventsCount eventCount, @NotNull Range range) {
            super(range);
            this.myRange = range;
            this.myLocationLegend = this.createSeriesLegend(eventCount.getLocationCountSeries());
            this.myWakeLockLegend = this.createSeriesLegend(eventCount.getWakeLockCountSeries());
            this.myAlarmAndJobLegend = this.createSeriesLegend(eventCount.getAlarmAndJobCountSeries());
            this.add((Legend)this.myLocationLegend);
            this.add((Legend)this.myWakeLockLegend);
            this.add((Legend)this.myAlarmAndJobLegend);
        }

        private SeriesLegend createSeriesLegend(RangedContinuousSeries series) {
            return new SeriesLegend(series, (BaseAxisFormatter)this.myFormatter, this.myRange, Interpolatable.SegmentInterpolator);
        }

        @NotNull
        public Legend getWakeLockLegend() {
            return this.myWakeLockLegend;
        }

        @NotNull
        public Legend getLocationLegend() {
            return this.myLocationLegend;
        }

        @NotNull
        public Legend getAlarmAndJobLegend() {
            return this.myAlarmAndJobLegend;
        }
    }

    public static class EnergyUsageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myNetworkLegend;
        @NotNull
        private final SeriesLegend myLocationLegend;

        EnergyUsageLegends(DetailedEnergyUsage detailedUsage, Range range) {
            super(range);
            this.myCpuLegend = new SeriesLegend(detailedUsage.getCpuUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "CPU", Interpolatable.SegmentInterpolator);
            this.myNetworkLegend = new SeriesLegend(detailedUsage.getNetworkUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "Network", Interpolatable.SegmentInterpolator);
            this.myLocationLegend = new SeriesLegend(detailedUsage.getLocationUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "Location", Interpolatable.SegmentInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myNetworkLegend);
            this.add((Legend)this.myLocationLegend);
        }

        @NotNull
        public Legend getCpuLegend() {
            return this.myCpuLegend;
        }

        @NotNull
        public Legend getNetworkLegend() {
            return this.myNetworkLegend;
        }

        @NotNull
        public SeriesLegend getLocationLegend() {
            return this.myLocationLegend;
        }
    }
}

