/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyDetailsView;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventMinibar;
import com.android.tools.profilers.energy.EnergyEventOrigin;
import com.android.tools.profilers.energy.EnergyEventsView;
import com.android.tools.profilers.energy.EnergyMonitorView;
import com.android.tools.profilers.energy.EnergyProfilerAspect;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyStageTooltip;
import com.android.tools.profilers.energy.EnergyStageTooltipView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class EnergyProfilerStageView
extends StageView<EnergyProfilerStage> {
    @NotNull
    private final JPanel myEventsPanel;
    @NotNull
    private final EnergyDetailsView myDetailsView;

    public EnergyProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull EnergyProfilerStage energyProfilerStage) {
        super(profilersView, energyProfilerStage);
        this.getTooltipBinder().bind(EnergyStageTooltip.class, EnergyStageTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, LifecycleTooltipView::new);
        this.getTooltipBinder().bind(UserEventTooltip.class, UserEventTooltipView::new);
        JBSplitter verticalSplitter = new JBSplitter(true);
        verticalSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        verticalSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        this.myEventsPanel = new JPanel((LayoutManager)new TabularLayout("Fit-,Fit-,*,Fit-", "Fit-,*"));
        this.myEventsPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        JLabel showLabel = new JLabel("Show");
        showLabel.setBorder((Border)new JBEmptyBorder(0, 11, 0, 8));
        showLabel.setFont(ProfilerFonts.STANDARD_FONT);
        this.myEventsPanel.add((Component)showLabel, new TabularLayout.Constraint(0, 0));
        JComponent configurationComponent = this.getConfigurationComponent();
        configurationComponent.setFont(ProfilerFonts.STANDARD_FONT);
        this.myEventsPanel.add((Component)configurationComponent, new TabularLayout.Constraint(0, 1));
        JLabel selectionTimeLabel = this.getSelectionTimeLabel();
        selectionTimeLabel.setBorder((Border)new JBEmptyBorder(0, 0, 0, 8));
        this.myEventsPanel.add((Component)selectionTimeLabel, new TabularLayout.Constraint(0, 3));
        JComponent eventsView = new EnergyEventsView(this).getComponent();
        this.myEventsPanel.add((Component)new JBScrollPane((Component)eventsView), new TabularLayout.Constraint(1, 0, 1, 4));
        this.myEventsPanel.setVisible(false);
        verticalSplitter.setSecondComponent((JComponent)this.myEventsPanel);
        this.myDetailsView = new EnergyDetailsView(this);
        this.myDetailsView.setMinimumSize(new Dimension(JBUI.scale((int)450), (int)this.myDetailsView.getMinimumSize().getHeight()));
        this.myDetailsView.setVisible(false);
        JBSplitter splitter = new JBSplitter(false, 0.6f);
        splitter.setFirstComponent((JComponent)verticalSplitter);
        splitter.setSecondComponent((JComponent)this.myDetailsView);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.getComponent().add((Component)splitter, "Center");
        ((EnergyProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)EnergyProfilerAspect.SELECTED_EVENT_DURATION, this::updateSelectedDurationView);
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((EnergyProfilerStage)this.getStage()).getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        SelectionComponent selection = new SelectionComponent(((EnergyProfilerStage)this.getStage()).getSelectionModel(), this.getTimeline().getViewRange());
        selection.setCursorSetter(ProfilerLayeredPane::setCursorOnProfilerLayeredPane);
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> selection.shouldShowSeekComponent());
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        panel.add((Component)tooltip, new TabularLayout.Constraint(0, 0, 2, 1));
        ProfilerScrollbar scrollbar = new ProfilerScrollbar(timeline, (JComponent)panel);
        panel.add((Component)((Object)scrollbar), new TabularLayout.Constraint(4, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(3, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((EnergyProfilerStage)this.getStage()).getEventMonitor());
        JComponent eventsComponent = eventsView.getComponent();
        panel.add((Component)eventsComponent, new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((EnergyProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        DetailedEnergyUsage usage = ((EnergyProfilerStage)this.getStage()).getDetailedUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig cpuConfig = new LineConfig(ProfilerColors.ENERGY_CPU).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getCpuUsageSeries(), cpuConfig);
        LineConfig networkConfig = new LineConfig(ProfilerColors.ENERGY_NETWORK).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getNetworkUsageSeries(), networkConfig);
        LineConfig locationConfig = new LineConfig(ProfilerColors.ENERGY_LOCATION).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getLocationUsageSeries(), locationConfig);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((EnergyProfilerStage)this.getStage()).getAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        EnergyProfilerStage.EnergyUsageLegends legends = ((EnergyProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure(legends.getCpuLegend(), new LegendConfig(lineChart.getLineConfig(usage.getCpuUsageSeries())));
        legend.configure(legends.getNetworkLegend(), new LegendConfig(lineChart.getLineConfig(usage.getNetworkUsageSeries())));
        legend.configure((Legend)legends.getLocationLegend(), new LegendConfig(lineChart.getLineConfig(usage.getLocationUsageSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        ((EnergyProfilerStage)this.getStage()).getSelectionModel().addListener(new SelectionListener(){

            public void selectionCreated() {
                EnergyProfilerStageView.this.myEventsPanel.setVisible(true);
            }

            public void selectionCleared() {
                EnergyProfilerStageView.this.myEventsPanel.setVisible(false);
            }

            public void selectionCreationFailure() {
                EnergyProfilerStageView.this.myEventsPanel.setVisible(false);
            }
        });
        selection.addSelectionUpdatedListener(selectionRange -> {
            if (((EnergyProfilerStage)this.getStage()).getSelectedDuration() != null) {
                EnergyDuration selectedDuration = ((EnergyProfilerStage)this.getStage()).getSelectedDuration();
                long detailsStartUs = TimeUnit.NANOSECONDS.toMicros(((EnergyProfiler.EnergyEvent)selectedDuration.getEventList().get(0)).getTimestamp());
                long detailsEndUs = detailsStartUs;
                if ((double)detailsEndUs < selectionRange.getMin()) {
                    selectedDuration = ((EnergyProfilerStage)this.getStage()).updateDuration(selectedDuration);
                    EnergyProfiler.EnergyEvent lastEvent = (EnergyProfiler.EnergyEvent)selectedDuration.getEventList().get(selectedDuration.getEventList().size() - 1);
                    long l = detailsEndUs = lastEvent.getIsTerminal() ? TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp()) : Long.MAX_VALUE;
                }
                if (selectionRange.getMax() < (double)detailsStartUs || selectionRange.getMin() > (double)detailsEndUs) {
                    ((EnergyProfilerStage)this.getStage()).setSelectedDuration(null);
                }
            }
        });
        JComponent minibar = new EnergyEventMinibar(this).getComponent();
        selection.addMouseListener((MouseListener)new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new EnergyStageTooltip((EnergyProfilerStage)this.getStage())));
        tooltip.registerListenersOn((JComponent)selection);
        eventsView.registerTooltip(tooltip, (Stage)((Object)this.getStage()));
        if (!((EnergyProfilerStage)this.getStage()).hasUserUsedEnergySelection()) {
            this.installProfilingInstructions((JPanel)monitorPanel);
        }
        this.getProfilersView().installCommonMenuItems((JComponent)selection);
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        JPanel stagePanel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit"));
        stagePanel.add((Component)monitorPanel, new TabularLayout.Constraint(0, 0));
        stagePanel.add((Component)minibar, new TabularLayout.Constraint(1, 0));
        layout.setRowSizing(1, "*");
        stagePanel.setBackground(null);
        panel.add((Component)selection, new TabularLayout.Constraint(1, 0));
        panel.add((Component)stagePanel, new TabularLayout.Constraint(1, 0));
        return panel;
    }

    @Override
    public JComponent getToolbar() {
        JPanel toolBar = new JPanel(ProfilerLayout.createToolbarLayout());
        JLabel textLabel = new JLabel();
        textLabel.setText("Modeled");
        textLabel.setFont(ProfilerFonts.H4_FONT);
        textLabel.setBorder((Border)new JBEmptyBorder(4, 8, 4, 7));
        toolBar.add(textLabel);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(StudioIcons.Common.HELP);
        toolBar.add(iconLabel);
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        textPane.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        textPane.setForeground(ProfilerColors.TOOLTIP_TEXT);
        textPane.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        textPane.setText("The Energy Profiler models your app's estimated energy usage of CPU, Network, and GPS resources of your device. It also highlights background events that may contribute to battery drain, such as wake locks, alarms, jobs, and location requests.");
        textPane.setPreferredSize(new Dimension(350, 0));
        TooltipComponent tooltip = new TooltipComponent.Builder((JComponent)textPane, (JComponent)iconLabel, this.getProfilersView().getComponent()).build();
        tooltip.registerListenersOn((Component)iconLabel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolBar, "West");
        return panel;
    }

    private void updateSelectedDurationView() {
        this.myDetailsView.setDuration(((EnergyProfilerStage)this.getStage()).getSelectedDuration());
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        assert (parent.getLayout().getClass() == TabularLayout.class);
        InstructionsPanel panel = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)parent, (Font)ProfilerFonts.H2_FONT), "Select a range to inspect energy events")}).setEaseOut(((EnergyProfilerStage)this.getStage()).getInstructionsEaseOutModel(), instructionPanel -> parent.remove((Component)instructionPanel)).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0));
    }

    private JComponent getConfigurationComponent() {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(EnergyEventOrigin.class));
        comboBox.getModel().setSelectedItem((Object)((EnergyProfilerStage)this.getStage()).getEventOrigin());
        comboBox.setRenderer(new ListCellRendererWrapper<EnergyEventOrigin>(){

            public void customize(JList list, EnergyEventOrigin value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getLabelString());
            }
        });
        comboBox.addActionListener(arg_0 -> this.lambda$getConfigurationComponent$4((JComboBox)comboBox, arg_0));
        return comboBox;
    }

    private /* synthetic */ void lambda$getConfigurationComponent$4(JComboBox comboBox, ActionEvent e) {
        Object origin = comboBox.getSelectedItem();
        if (origin instanceof EnergyEventOrigin) {
            ((EnergyProfilerStage)this.getStage()).setEventOrigin((EnergyEventOrigin)((Object)origin));
        }
    }
}

