/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.android.tools.profilers.energy.EnergyStageTooltip;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class EnergyStageTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final EnergyStageTooltip myTooltip;

    public EnergyStageTooltipView(@NotNull EnergyProfilerStageView stageView, @NotNull EnergyStageTooltip tooltip) {
        super(stageView.getTimeline());
        this.myTooltip = tooltip;
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        EnergyProfilerStage.EnergyUsageLegends usageLegends = this.myTooltip.getUsageLegends();
        LegendComponent usageLegendComponent = new LegendComponent.Builder((LegendComponentModel)usageLegends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        usageLegendComponent.configure(usageLegends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_CPU));
        usageLegendComponent.configure(usageLegends.getNetworkLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_NETWORK));
        usageLegendComponent.configure((Legend)usageLegends.getLocationLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_LOCATION));
        EnergyProfilerStage.EnergyEventLegends eventLegends = this.myTooltip.getEventLegends();
        LegendComponent eventLegendComponent = new LegendComponent.Builder((LegendComponentModel)eventLegends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        eventLegendComponent.configure(eventLegends.getLocationLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_LOCATION));
        eventLegendComponent.configure(eventLegends.getWakeLockLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_WAKE_LOCK));
        eventLegendComponent.configure(eventLegends.getAlarmAndJobLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_BACKGROUND));
        eventLegends.changed((Enum)LegendComponentModel.Aspect.LEGEND);
        JPanel legendPanel = new JPanel((LayoutManager)new TabularLayout("*", "Fit,8px,Fit,8px,Fit,Fit,Fit"));
        legendPanel.setOpaque(false);
        legendPanel.add((Component)usageLegendComponent, new TabularLayout.Constraint(0, 0));
        JLabel eventLabel = new JLabel("System Events");
        eventLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        eventLabel.setFont(ProfilerFonts.STANDARD_FONT);
        Color color = eventLabel.getForeground();
        eventLabel.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 153));
        JPanel labelWithSeparator = new JPanel((LayoutManager)new TabularLayout("Fit,8px,*", "Fit"));
        labelWithSeparator.add((Component)eventLabel, new TabularLayout.Constraint(0, 0));
        labelWithSeparator.add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(0, 2));
        labelWithSeparator.setOpaque(false);
        legendPanel.add((Component)labelWithSeparator, new TabularLayout.Constraint(2, 0));
        legendPanel.add((Component)eventLegendComponent, new TabularLayout.Constraint(4, 0));
        legendPanel.add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(5, 0));
        JLabel callToActionLabel = new JLabel("Select range to inspect");
        callToActionLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        callToActionLabel.setFont(ProfilerFonts.STANDARD_FONT);
        callToActionLabel.setForeground(eventLabel.getForeground());
        legendPanel.add((Component)callToActionLabel, new TabularLayout.Constraint(6, 0));
        return legendPanel;
    }
}

