/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.profilers.energy.EnergyProfilerStage;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EnergyTraceCache {
    @NotNull
    private final Map<String, String> myTraceCacheMap = new HashMap<String, String>();
    @NotNull
    private final EnergyProfilerStage myStage;

    EnergyTraceCache(@NotNull EnergyProfilerStage stage) {
        this.myStage = stage;
    }

    @NotNull
    public String getTraceData(@NotNull String traceId) {
        String[] qualifiedMethodSplit;
        if (!this.myTraceCacheMap.containsKey(traceId) && (qualifiedMethodSplit = this.myStage.requestBytes(traceId).toStringUtf8().split("\\(", 2)).length > 0) {
            this.myTraceCacheMap.put(traceId, qualifiedMethodSplit[0]);
        }
        return this.myTraceCacheMap.get(traceId);
    }
}

