/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleEvent;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorTooltip;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.LifecycleEventDataSeries;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.UserEventDataSeries;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class EventMonitor
extends ProfilerMonitor {
    @NotNull
    private final EventModel<UserEvent> myUserEvents;
    @NotNull
    private final EventModel<LifecycleEvent> myActivityEvents;
    @NotNull
    private final EventModel<LifecycleEvent> myFragmentEvents;
    private boolean myEnabled;
    private Supplier<ProfilerMonitorTooltip<EventMonitor>> myTooltipBuilder;

    public EventMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        UserEventDataSeries events = new UserEventDataSeries(this.myProfilers);
        this.myUserEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)events));
        LifecycleEventDataSeries activities = new LifecycleEventDataSeries(this.myProfilers, false);
        this.myActivityEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)activities));
        if (this.myProfilers.getIdeServices().getFeatureConfig().isFragmentsEnabled()) {
            LifecycleEventDataSeries fragments = new LifecycleEventDataSeries(this.myProfilers, true);
            this.myFragmentEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)fragments));
        } else {
            this.myFragmentEvents = new EventModel(new RangedSeries(new Range(1.0, -1.0), (DataSeries)new DataSeries<EventAction<LifecycleEvent>>(){

                public List<SeriesData<EventAction<LifecycleEvent>>> getDataForXRange(Range xRange) {
                    return new ArrayList<SeriesData<EventAction<LifecycleEvent>>>();
                }
            }));
        }
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::onAgentStatusChanged);
        this.onAgentStatusChanged();
    }

    @Override
    public void enter() {
    }

    @Override
    public void exit() {
    }

    @NotNull
    public EventModel<UserEvent> getUserEvents() {
        return this.myUserEvents;
    }

    @NotNull
    public EventModel<LifecycleEvent> getActivityEvents() {
        return this.myActivityEvents;
    }

    @NotNull
    public EventModel<LifecycleEvent> getFragmentEvents() {
        return this.myFragmentEvents;
    }

    @Override
    public String getName() {
        return "EVENTS";
    }

    @Override
    public ProfilerTooltip buildTooltip() {
        if (this.myTooltipBuilder != null) {
            return this.myTooltipBuilder.get();
        }
        return new LifecycleTooltip(this);
    }

    public void setTooltipBuilder(Supplier<ProfilerMonitorTooltip<EventMonitor>> tooltip) {
        this.myTooltipBuilder = tooltip;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void onAgentStatusChanged() {
        boolean agentAttached = this.myProfilers.isAgentAttached();
        if (this.myEnabled != agentAttached) {
            this.myEnabled = agentAttached;
            this.changed(ProfilerMonitor.Aspect.ENABLE);
        }
    }
}

