/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.ActivityComponent;
import com.android.tools.adtui.EventComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.eventrenderer.EventIconRenderer;
import com.android.tools.adtui.eventrenderer.EventRenderer;
import com.android.tools.adtui.eventrenderer.KeyboardEventRenderer;
import com.android.tools.adtui.eventrenderer.TouchEventRenderer;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.profilers.ProfilerMonitorTooltip;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.UserEventTooltip;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EventMonitorView
extends ProfilerMonitorView<EventMonitor> {
    private static final Map<UserEvent, EventRenderer<UserEvent>> RENDERERS = new HashMap<UserEvent, EventRenderer<UserEvent>>();
    private EventComponent<UserEvent> myUserEventComponent;
    private ActivityComponent myActivityComponent;

    public EventMonitorView(@NotNull StudioProfilersView profilersView, @NotNull EventMonitor monitor) {
        super(monitor);
        this.initializeComponents();
    }

    private void initializeComponents() {
        if (this.myActivityComponent == null) {
            this.myActivityComponent = new ActivityComponent(((EventMonitor)((Object)this.getMonitor())).getActivityEvents(), ((EventMonitor)((Object)this.getMonitor())).getFragmentEvents());
        }
        if (this.myUserEventComponent == null) {
            this.myUserEventComponent = new EventComponent(((EventMonitor)((Object)this.getMonitor())).getUserEvents(), RENDERERS);
        }
    }

    @Override
    public float getVerticalWeight() {
        return 0.0f;
    }

    @Override
    public void registerTooltip(@NotNull RangeTooltipComponent tooltip, Stage stage) {
        this.registerComponent((JComponent)this.myUserEventComponent, () -> new UserEventTooltip((EventMonitor)((Object)((Object)this.getMonitor()))), tooltip, stage);
        this.registerComponent((JComponent)this.myActivityComponent, () -> new LifecycleTooltip((EventMonitor)((Object)((Object)this.getMonitor()))), tooltip, stage);
    }

    private void registerComponent(JComponent component, final Supplier<ProfilerMonitorTooltip<EventMonitor>> tooltip, RangeTooltipComponent tooltipComponent, final Stage stage) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((EventMonitor)EventMonitorView.this.getMonitor()).isEnabled()) {
                    ((EventMonitor)EventMonitorView.this.getMonitor()).setTooltipBuilder(tooltip);
                    stage.setTooltip(((EventMonitor)EventMonitorView.this.getMonitor()).buildTooltip());
                } else {
                    stage.setTooltip(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                stage.setTooltip(null);
            }
        });
        tooltipComponent.registerListenersOn(component);
    }

    @Override
    protected void populateUi(JPanel container) {
        this.initializeComponents();
        container.setLayout((LayoutManager)new TabularLayout("*", "*,*"));
        container.add((Component)this.myUserEventComponent, new TabularLayout.Constraint(0, 0));
        container.add((Component)this.myActivityComponent, new TabularLayout.Constraint(1, 0));
    }

    static {
        RENDERERS.put(UserEvent.TOUCH, (EventRenderer<UserEvent>)new TouchEventRenderer());
        RENDERERS.put(UserEvent.ROTATION, (EventRenderer<UserEvent>)new EventIconRenderer(StudioIcons.Profiler.Events.ROTATE_EVENT));
        RENDERERS.put(UserEvent.KEYBOARD, (EventRenderer<UserEvent>)new KeyboardEventRenderer());
    }
}

