/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.LifecycleAction;
import com.android.tools.adtui.model.event.LifecycleEvent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.Interaction;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LifecycleEventDataSeries
implements DataSeries<EventAction<LifecycleEvent>> {
    @NotNull
    private StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    private final boolean myFragmentsOnly;

    public LifecycleEventDataSeries(@NotNull StudioProfilers profilers, boolean fragmentOnly) {
        this.myProfilers = profilers;
        this.mySession = profilers.getSession();
        this.myFragmentsOnly = fragmentOnly;
    }

    public List<SeriesData<EventAction<LifecycleEvent>>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return this.getTransportData(timeCurrentRangeUs);
        }
        return this.getLegacyData(timeCurrentRangeUs);
    }

    @NotNull
    private List<SeriesData<EventAction<LifecycleEvent>>> getTransportData(@NotNull Range rangeUs) {
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> series = new ArrayList<SeriesData<EventAction<LifecycleEvent>>>();
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.VIEW).setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            boolean isFragment;
            boolean bl = isFragment = group.getEvents(0).getView().getParentActivityId() != 0L;
            if (this.myFragmentsOnly != isFragment) continue;
            long actionStart = 0L;
            long actionEnd = 0L;
            boolean hasEndEvent = false;
            LifecycleEvent lifecycleEvent = LifecycleEvent.NONE;
            for (int i = 0; i < group.getEventsCount(); ++i) {
                Common.Event event = group.getEvents(i);
                Interaction.ViewData data2 = event.getView();
                String displayString = data2.getName();
                switch (data2.getState()) {
                    case ADDED: 
                    case RESUMED: {
                        lifecycleEvent = LifecycleEvent.STARTED;
                        actionStart = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                        break;
                    }
                    case DESTROYED: {
                        if (i != group.getEventsCount() - 1) break;
                        displayString = displayString + String.format(" - %s", data2.getState().toString().toLowerCase());
                    }
                    case REMOVED: 
                    case PAUSED: {
                        lifecycleEvent = LifecycleEvent.COMPLETED;
                        actionEnd = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                        hasEndEvent = true;
                        break;
                    }
                }
                if (hasEndEvent) {
                    while (++i < group.getEventsCount()) {
                        Common.Event nextEvent = group.getEvents(i);
                        if (nextEvent.getIsEnded()) {
                            displayString = displayString + String.format(" - %s", nextEvent.getView().getState().toString().toLowerCase());
                            continue;
                        }
                        --i;
                        break;
                    }
                }
                if (!hasEndEvent && (i != group.getEventsCount() - 1 || actionStart == 0L)) continue;
                series.add((SeriesData<EventAction<LifecycleEvent>>)new SeriesData(actionStart, (Object)new LifecycleAction(actionStart, actionEnd, lifecycleEvent, displayString, event.getGroupId())));
                actionStart = 0L;
                actionEnd = 0L;
                hasEndEvent = false;
                lifecycleEvent = LifecycleEvent.NONE;
            }
        }
        Collections.sort(series, Comparator.comparingLong(data -> data.x));
        return series;
    }

    @NotNull
    private List<SeriesData<EventAction<LifecycleEvent>>> getLegacyData(@NotNull Range rangeUs) {
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> seriesData = new ArrayList<SeriesData<EventAction<LifecycleEvent>>>();
        EventServiceGrpc.EventServiceBlockingStub eventService = this.myProfilers.getClient().getEventClient();
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax()));
        EventProfiler.ActivityDataResponse response = eventService.getActivityData(dataRequestBuilder.build());
        for (EventProfiler.ActivityData data : response.getDataList()) {
            boolean isFragment;
            long actionStart = 0L;
            long actionEnd = 0L;
            boolean bl = isFragment = data.getActivityContextHash() != 0L;
            if (this.myFragmentsOnly != isFragment) continue;
            boolean haveEvent = false;
            for (int i = 0; i < data.getStateChangesCount(); ++i) {
                EventProfiler.ActivityStateData state = data.getStateChanges(i);
                LifecycleEvent lifecycleEvent = LifecycleEvent.NONE;
                String displayString = data.getName();
                switch (state.getState()) {
                    case ADDED: 
                    case RESUMED: {
                        lifecycleEvent = LifecycleEvent.STARTED;
                        actionStart = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        break;
                    }
                    case DESTROYED: {
                        if (i != data.getStateChangesCount() - 1) break;
                        displayString = String.format("%s - %s", displayString, state.getState().toString().toLowerCase());
                    }
                    case REMOVED: 
                    case PAUSED: {
                        lifecycleEvent = LifecycleEvent.COMPLETED;
                        actionEnd = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        haveEvent = true;
                        break;
                    }
                }
                while (haveEvent && ++i < data.getStateChangesCount()) {
                    state = data.getStateChanges(i);
                    Interaction.ViewData.State activityState = state.getState();
                    if (this.getComponentInStartingOrRunningState(activityState)) {
                        --i;
                        break;
                    }
                    displayString = String.format("%s - %s", displayString, state.getState().toString().toLowerCase());
                }
                if (!haveEvent && (i != data.getStateChangesCount() - 1 || lifecycleEvent == LifecycleEvent.NONE)) continue;
                seriesData.add((SeriesData<EventAction<LifecycleEvent>>)new SeriesData(actionStart, (Object)new LifecycleAction(actionStart, actionEnd, lifecycleEvent, displayString, data.getHash())));
                actionEnd = 0L;
                actionStart = 0L;
                haveEvent = false;
            }
        }
        return seriesData;
    }

    private boolean getComponentInStartingOrRunningState(Interaction.ViewData.State state) {
        switch (state) {
            case ADDED: 
            case RESUMED: 
            case ATTACHED: 
            case CREATED: 
            case CREATEDVIEW: 
            case ACTIVITYCREATED: 
            case STARTED: {
                return true;
            }
        }
        return false;
    }
}

