/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class AllocStatsDataSeries
implements DataSeries<Long> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final AspectObserver myObserver;
    private boolean myIsAgentAttached = false;
    @NotNull
    private Function<MemoryProfiler.MemoryData.AllocStatsSample, Long> myFilter;

    public AllocStatsDataSeries(@NotNull StudioProfilers profilers, @NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Function<MemoryProfiler.MemoryData.AllocStatsSample, Long> filter) {
        this.myProfilers = profilers;
        this.myClient = client;
        this.mySession = this.myProfilers.getSession();
        this.myFilter = filter;
        this.myObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.agentStatusChanged();
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (!this.myIsAgentAttached) {
            return Collections.emptyList();
        }
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        MemoryProfiler.MemoryData response = this.myClient.getData(dataRequestBuilder.build());
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : response.getAllocStatsSamplesList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp());
            seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)this.myFilter.apply(sample)));
        }
        return seriesData;
    }

    private void agentStatusChanged() {
        this.myIsAgentAttached = this.myProfilers.isAgentAttached();
    }
}

