/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AllocationInfosDataSeries
extends CaptureDataSeries<CaptureObject> {
    @Nullable
    private MemoryProfilerStage myStage;

    public AllocationInfosDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull FeatureTracker featureTracker, @Nullable MemoryProfilerStage stage) {
        super(client, session, featureTracker);
        this.myStage = stage;
    }

    @NotNull
    List<MemoryProfiler.AllocationsInfo> getInfoForTimeRangeNs(long rangeMinNs, long rangeMaxNs) {
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(rangeMinNs).setEndTime(rangeMaxNs);
        MemoryProfiler.MemoryData response = this.myClient.getData(dataRequestBuilder.build());
        return response.getAllocationsInfoList();
    }

    public List<SeriesData<CaptureDurationData<CaptureObject>>> getDataForXRange(Range xRange) {
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin()) - bufferNs;
        long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax()) + bufferNs;
        List<MemoryProfiler.AllocationsInfo> infos = this.getInfoForTimeRangeNs(rangeMin, rangeMax);
        ArrayList<SeriesData<CaptureDurationData<CaptureObject>>> seriesData = new ArrayList<SeriesData<CaptureDurationData<CaptureObject>>>();
        for (MemoryProfiler.AllocationsInfo info : infos) {
            long startTimeNs = info.getStartTime();
            long durationUs = AllocationInfosDataSeries.getDurationUs(startTimeNs, info.getEndTime());
            seriesData.add((SeriesData<CaptureDurationData<CaptureObject>>)new SeriesData(AllocationInfosDataSeries.getHostTime(startTimeNs), new CaptureDurationData<CaptureObject>(durationUs, !info.getLegacy(), !info.getLegacy(), new CaptureEntry<CaptureObject>(info, () -> {
                if (info.getLegacy()) {
                    return new LegacyAllocationCaptureObject(this.myClient, this.mySession, info, this.myFeatureTracker);
                }
                return new LiveAllocationCaptureObject(this.myClient, this.mySession, startTimeNs, null, this.myStage);
            }))));
        }
        return seriesData;
    }
}

